<?php
class DailyReadings
{
    public $daily_readings_options;

    public function __construct()
    {
        add_action('admin_menu', array(
            $this,
            'daily_readings_add_plugin_page'
        ));
        add_action('admin_init', array(
            $this,
            'daily_readings_page_init'
        ));
        add_action('plugins_loaded', array(
            $this,
            'daily_readings_load_translations'
        ));
    }

    public function daily_readings_load_translations()
    {
        load_plugin_textdomain('daily-readings', false, 'daily-readings/languages');
    }

    public function getDaily_readings_options()
    {
        return $this->daily_readings_options;
    }

    public function daily_readings_add_plugin_page()
    {
        add_menu_page(__('Daily Readings', 'daily-readings') , // page_title
        __('Daily Readings', 'daily-readings') , // menu_title
        'manage_options', // capability
        'daily-readings', // menu_slug
        array(
            $this,
            'daily_readings_create_admin_page'
        ) , // function
        'dashicons-book-alt', // icon_url
        21
        // position
        );
    }

    public function daily_readings_create_admin_page()
    {
        $this->daily_readings_options = get_option('daily_readings_option_name'); ?>

        <div class="daily-readings-wrap">
            <h2><?php _e('Daily Readings', 'daily-readings') ?></h2>
            <p><?php _e('Mass Daily Readings according to different rites', 'daily-readings') ?></p>
            <p><?php _e('Configure the settings and paste this shortcode <code id="daily-readings-shortcode">[sc_daily_readings]</code> in a page for rendering the component', 'daily-readings') ?></p>
            <?php settings_errors(); ?>

            <form method="post" action="options.php">
                <?php
        settings_fields('daily_readings_option_group');
        do_settings_sections('daily-readings-admin');
        submit_button();
?>
            </form>
            <div id="daily-readings-snackbar"><?php _e('Copied to clipboard', 'daily-readings') ?></div>
        </div>
    <?php
    }

    public function daily_readings_page_init()
    {
        register_setting('daily_readings_option_group', // option_group
        'daily_readings_option_name', // option_name
        array(
            $this,
            'daily_readings_sanitize'
        ) // sanitize_callback
        );

        add_settings_section('daily_readings_setting_section', // id
        __('Settings') , // title
        array(
            $this,
            'daily_readings_section_info'
        ) , // callback
        'daily-readings-admin'
        // page
        );

        add_settings_field('rite_0', // id
        __('Rite', 'daily-readings') , // title
        array(
            $this,
            'daily_readings_rite_0_callback'
        ) , // callback
        'daily-readings-admin', // page
        'daily_readings_setting_section'
        // section
        );

        add_settings_field('color_1', // id
        __('Color', 'daily-readings') , // title
        array(
            $this,
            'daily_readings_color_1_callback'
        ) , // callback
        'daily-readings-admin', // page
        'daily_readings_setting_section'
        // section
        );

        add_settings_field('readings_to_hide_2', // id
        __('Readings to hide', 'daily-readings') , // title
        array(
            $this,
            'daily_readings_readings_to_hide_2_callback'
        ) , // callback
        'daily-readings-admin', // page
        'daily_readings_setting_section'
        // section
        );

        add_settings_field('time_zone_7', // id
        __('Time zone', 'daily-readings') , // title
        array(
            $this,
            'daily_readings_time_zone_7_callback'
        ) , // callback
        'daily-readings-admin', // page
        'daily_readings_setting_section'
        // section
        );

        add_action('admin_enqueue_scripts', array(
            $this,
            'daily_readings_enqueue_color_picker'
        ));
        wp_enqueue_style('daily-readings-css', plugins_url('../style.css', __FILE__));
    }

    public function daily_readings_section_info()
    {
    } // empty
    public function daily_readings_enqueue_color_picker()
    {
        $page = 'UndefinedPage';
        if (isset($_GET['page']))
        {
            $page = $_GET['page'];
        }

        if (in_array($page, array(
            'daily-readings'
        )))
        {
            wp_enqueue_style('wp-color-picker');
            wp_enqueue_script('daily-readings-handle', plugins_url('../daily-readings-backend-settings.js', __FILE__) , array(
                'jquery',
                'wp-color-picker'
            ));
        }
    }

    public function daily_readings_sanitize($input)
    {
        $sanitary_values = array();
        if (isset($input['rite_0']))
        {
            $sanitary_values['rite_0'] = $input['rite_0'];
        }

        if (isset($input['color_1']))
        {
            $sanitary_values['color_1'] = sanitize_text_field($input['color_1']);
        }

        if (isset($input['hide_first_reading_2']))
        {
            $sanitary_values['hide_first_reading_2'] = $input['hide_first_reading_2'];
        }

        if (isset($input['hide_psalm_3']))
        {
            $sanitary_values['hide_psalm_3'] = $input['hide_psalm_3'];
        }

        if (isset($input['hide_second_reading_4']))
        {
            $sanitary_values['hide_second_reading_4'] = $input['hide_second_reading_4'];
        }

        if (isset($input['hide_gospel_5']))
        {
            $sanitary_values['hide_gospel_5'] = $input['hide_gospel_5'];
        }

        if (isset($input['show_short_titles']))
        {
            $sanitary_values['show_short_titles'] = $input['show_short_titles'];
        }

        if (isset($input['time_zone_7']))
        {
            $sanitary_values['time_zone_7'] = $input['time_zone_7'];
        }

        return $sanitary_values;
    }

    public function daily_readings_rite_0_callback()
    { ?> 
        <select name="daily_readings_option_name[rite_0]" id="rite_0">

            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'AR') ? 'selected' : ''; ?>
                    <option value="AR" <?php echo $selected; ?>><?php _e('Latin calendar (Arabic) - التقويم اللاتيني', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'BYA') ? 'selected' : ''; ?>
                    <option value="BYA" <?php echo $selected; ?>><?php _e('Melkite Roman Catholic calendar (Arabic) - تقويم الروم الملكيّين الكاثوليك', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'CHA') ? 'selected' : ''; ?>
                    <option value="CHA" <?php echo $selected; ?>><?php _e('Chaldean calendar (Arabic) - التقويم الكلدانيّ', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'COA') ? 'selected' : ''; ?>
                    <option value="COA" <?php echo $selected; ?>><?php _e('Coptic Catholic calendar (G) (Arabic) - التقويم القبطيّ الكاثوليكيّ (غ)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'MAA') ? 'selected' : ''; ?>
                    <option value="MAA" <?php echo $selected; ?>><?php _e('Maronite calendar (Arabic) - التقويم المارونيّ', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'SYA') ? 'selected' : ''; ?>
                    <option value="SYA" <?php echo $selected; ?>><?php _e('Syriac Catholic calendar (Arabic) - التقويم السريانيّ الكاثوليكيّ', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'DE') ? 'selected' : ''; ?>
                    <option value="DE" <?php echo $selected; ?>><?php _e('Römischer gewöhnlicher kalender (German)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'TRD') ? 'selected' : ''; ?>
                    <option value="TRD" <?php echo $selected; ?>><?php _e('Außerordentlicher kalender (German)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'GR') ? 'selected' : ''; ?>
                    <option value="GR" <?php echo $selected; ?>><?php _e('Ελληνικό ημερολόγιο (Greek)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'AM') ? 'selected' : ''; ?>
                    <option value="AM" <?php echo $selected; ?>><?php _e('Roman Ordinary calendar (English)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'MAE') ? 'selected' : ''; ?>
                    <option value="MAE" <?php echo $selected; ?>><?php _e('Maronite calendar (English)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'TRA') ? 'selected' : ''; ?>
                    <option value="TRA" <?php echo $selected; ?>><?php _e('Extraordinary calendar (English)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'BYE') ? 'selected' : ''; ?>
                    <option value="BYE" <?php echo $selected; ?>><?php _e('Byzantine calendar (English)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'SYE') ? 'selected' : ''; ?>
                    <option value="SYE" <?php echo $selected; ?>><?php _e('Syriac calendar (English)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'HE') ? 'selected' : ''; ?>
                    <option value="HE" <?php echo $selected; ?>><?php _e('Roman calendar (Jewish) - לוח הקראות הרומי', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'SP') ? 'selected' : ''; ?>
                    <option value="SP" <?php echo $selected; ?>><?php _e('Calendario ordinario (Spanish)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'TRS') ? 'selected' : ''; ?>
                    <option value="TRS" <?php echo $selected; ?>><?php _e('Calendario extraordinario (Spanish)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'GA') ? 'selected' : ''; ?>
                    <option value="GA" <?php echo $selected; ?>><?php _e('Féilire gnáth Rómhánach (Gaelic)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'ARM') ? 'selected' : ''; ?>
                    <option value="ARM" <?php echo $selected; ?>><?php _e('Armenian calendar (Armenian) - հայերեն օրացույցը', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'FR') ? 'selected' : ''; ?>
                    <option value="FR" <?php echo $selected; ?>><?php _e('Calendrier ordinaire (French)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'MAF') ? 'selected' : ''; ?>
                    <option value="MAF" <?php echo $selected; ?>><?php _e('Calendrier Maronite (French)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'TRF') ? 'selected' : ''; ?>
                    <option value="TRF" <?php echo $selected; ?>><?php _e('Calendrier extraordinaire (French)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'IT') ? 'selected' : ''; ?>
                    <option value="IT" <?php echo $selected; ?>><?php _e('Calendario Romano (Italian)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'MI') ? 'selected' : ''; ?>
                    <option value="MI" <?php echo $selected; ?>><?php _e('Calendario Ambrosiano (Italian)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'KR') ? 'selected' : ''; ?>
                    <option value="KR" <?php echo $selected; ?>><?php _e('로마의 보통 달력 (Korean) - Roman regular calendar', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'MG') ? 'selected' : ''; ?>
                    <option value="MG" <?php echo $selected; ?>><?php _e('Tetiandro tsotra (Malagasy) - Simple calendar', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'NL') ? 'selected' : ''; ?>
                    <option value="NL" <?php echo $selected; ?>><?php _e('Gewone kalender (Dutch)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'PL') ? 'selected' : ''; ?>
                    <option value="PL" <?php echo $selected; ?>><?php _e('Kalendarz rzymski (Polish)', 'daily-readings') ?></option> 
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'PT') ? 'selected' : ''; ?>
                    <option value="PT" <?php echo $selected; ?>><?php _e('Calendário ordinário (Portuguese)', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'RU') ? 'selected' : ''; ?>
                    <option value="RU" <?php echo $selected; ?>><?php _e('Roman Обычный календарь (Russian) - Roman Regular calendar', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'TR') ? 'selected' : ''; ?>
                    <option value="TR" <?php echo $selected; ?>><?php _e('Türk versiyonu (Turkish) - Turkish version', 'daily-readings') ?></option>
            <?php $selected = (isset($this->daily_readings_options['rite_0']) && $this->daily_readings_options['rite_0'] === 'CN') ? 'selected' : ''; ?>
                    <option value="CN" <?php echo $selected; ?>><?php _e('罗马普通日历 (Chinese) - General Roman Calendar', 'daily-readings') ?></option> 
        </select> 

    <?php
    }

    public function daily_readings_color_1_callback()
    {
        printf('<input class="daily-readings-color-picker-field" type="text" name="daily_readings_option_name[color_1]" id="color_1" value="%s"><br><p><i>' . __('Choose the color of the reading heading', 'daily-readings') . '</i></p>', isset($this->daily_readings_options['color_1']) ? esc_attr($this->daily_readings_options['color_1']) : '');
    }

    public function daily_readings_readings_to_hide_2_callback()
    {
        add_action('call_readings', array(
            $this,
            'daily_readings_hide_first_reading_2_callback'
        ));
        add_action('call_readings', array(
            $this,
            'daily_readings_hide_psalm_3_callback'
        ));
        add_action('call_readings', array(
            $this,
            'daily_readings_hide_second_reading_4_callback'
        ));
        add_action('call_readings', array(
            $this,
            'daily_readings_hide_gospel_5_callback'
        ));
        add_action('call_readings', array(
            $this,
            'daily_readings_tooltip_6_callback'
        ));
        /*add_action('call_readings', array(
            $this,
            'daily_readings_show_short_titles_callback'
        ));
        add_action('call_readings', array(
            $this,
            'daily_readings_tooltip_callback'
        ));*/
        do_action('call_readings');
    }

    public function daily_readings_hide_first_reading_2_callback()
    {
        printf('<div class="daily-readings-readings-to-hide"><input type="checkbox" name="daily_readings_option_name[hide_first_reading_2]" id="hide_first_reading_2" value="hide_first_reading_2" %s><label for="hide_first_reading_2">' . __('First Reading', 'daily-readings') . '</label></div>', (isset($this->daily_readings_options['hide_first_reading_2']) && $this->daily_readings_options['hide_first_reading_2'] === 'hide_first_reading_2') ? 'checked' : '');
    }

    public function daily_readings_hide_psalm_3_callback()
    {
        printf('<div class="daily-readings-readings-to-hide"><input type="checkbox" name="daily_readings_option_name[hide_psalm_3]" id="hide_psalm_3" value="hide_psalm_3" %s><label for="hide_psalm_3">' . __('Psalm', 'daily-readings') . '</label></div>', (isset($this->daily_readings_options['hide_psalm_3']) && $this->daily_readings_options['hide_psalm_3'] === 'hide_psalm_3') ? 'checked' : '');
    }

    public function daily_readings_hide_second_reading_4_callback()
    {
        printf('<div class="daily-readings-readings-to-hide"><input type="checkbox" name="daily_readings_option_name[hide_second_reading_4]" id="hide_second_reading_4" value="hide_second_reading_4" %s><label for="hide_second_reading_4">' . __('Second Reading', 'daily-readings') . '</label></div>', (isset($this->daily_readings_options['hide_second_reading_4']) && $this->daily_readings_options['hide_second_reading_4'] === 'hide_second_reading_4') ? 'checked' : '');
    }

    public function daily_readings_hide_gospel_5_callback()
    {
        printf('<div class="daily-readings-readings-to-hide"><input type="checkbox" name="daily_readings_option_name[hide_gospel_5]" id="hide_gospel_5" value="hide_gospel_5" %s><label for="hide_gospel_5">' . __('Gospel', 'daily-readings') . '</label></div>', (isset($this->daily_readings_options['hide_gospel_5']) && $this->daily_readings_options['hide_gospel_5'] === 'hide_gospel_5') ? 'checked' : '');
    }

    public function daily_readings_tooltip_6_callback()
    {
         printf('<br><p><i>' . __('Tick the checkbox if you don\'t want to render a daily reading', 'daily-readings') . '</i></p><br>');
    }

    public function daily_readings_show_short_titles_callback()
    {
        printf('<div class="daily-readings-readings-to-hide"><input type="checkbox" name="daily_readings_option_name[show_short_titles]" id="show_short_titles" value="show_short_titles" %s><label for="show_short_titles">' . __('Mostra solo i titoli', 'daily-readings') . '</label></div>', (isset($this->daily_readings_options['show_short_titles']) && $this->daily_readings_options['show_short_titles'] === 'show_short_titles') ? 'checked' : '');
    }

    public function daily_readings_tooltip_callback()
    {
         printf('<br><p><i>' . __('Tick the checkbox if you want to show the titles of the a daily reading you decided to hide', 'daily-readings') . '</i></p>');
    }

    public function daily_readings_time_zone_7_callback()
    { ?> 
            <select name="daily_readings_option_name[time_zone_7]" id="time_zone_7">
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === 'default') ? 'selected' : ''; ?>
                <option value="default" <?php echo $selected; ?>>Default</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-12 hours') ? 'selected' : ''; ?>
                <option value="-12 hours" <?php echo $selected; ?>>(GMT -12.00) Eniwetok, Kwajalein</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-11 hours') ? 'selected' : ''; ?>
                <option value="-11 hours" <?php echo $selected; ?>>(GMT -11.00) Midway Island, Samoa</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-10 hours') ? 'selected' : ''; ?>
                <option value="-10 hours" <?php echo $selected; ?>>(GMT -10.00) Hawaii</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-9 hours -30 minutes') ? 'selected' : ''; ?>
                <option value="-9 hours -30 minutes" <?php echo $selected; ?>>(GMT -9.30) Taiohae</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-9 hours') ? 'selected' : ''; ?>
                <option value="-9 hours" <?php echo $selected; ?>>(GMT -9.00) Alaska</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-8 hours') ? 'selected' : ''; ?>
                <option value="-8 hours" <?php echo $selected; ?>>(GMT -8.00) Pacific Time (US &amp; Canada)</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-7 hours') ? 'selected' : ''; ?>
                <option value="-7 hours" <?php echo $selected; ?>>(GMT -7.00) Mountain Time (US &amp; Canada)</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-6 hours') ? 'selected' : ''; ?>
                <option value="-6 hours" <?php echo $selected; ?>>(GMT -6.00) Central Time (US &amp; Canada), Mexico City</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-5 hours') ? 'selected' : ''; ?>
                <option value="-5 hours" <?php echo $selected; ?>>(GMT -5.00) Eastern Time (US &amp; Canada), Bogota, Lima</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-4 hours -30 minutes') ? 'selected' : ''; ?>
                <option value="-4 hours -30 minutes" <?php echo $selected; ?>>(GMT -4.30) Caracas</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-4 hours') ? 'selected' : ''; ?>
                <option value="-4 hours" <?php echo $selected; ?>>(GMT -4.00) Atlantic Time (Canada), Caracas, La Paz</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-3 hours -30 minutes') ? 'selected' : ''; ?>
                <option value="-3 hours -30 minutes" <?php echo $selected; ?>>(GMT -3.30) Newfoundland</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-3 hours') ? 'selected' : ''; ?>
                <option value="-3 hours" <?php echo $selected; ?>>(GMT -3.00) Brazil, Buenos Aires, Georgetown</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-2 hours') ? 'selected' : ''; ?>
                <option value="-2 hours" <?php echo $selected; ?>>(GMT -2.00) Mid-Atlantic</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '-1 hour') ? 'selected' : ''; ?>
                <option value="-1 hour" <?php echo $selected; ?>>(GMT -1.00) Azores, Cape Verde Islands</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+0') ? 'selected' : ''; ?>
                <option value="+0" <?php echo $selected; ?>>(GMT) Western Europe Time, London, Lisbon, Casablanca</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+1 hour') ? 'selected' : ''; ?>
                <option value="+1 hour" <?php echo $selected; ?>>(GMT +1.00) Brussels, Copenhagen, Madrid, Paris, Rome</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+2 hours') ? 'selected' : ''; ?>
                <option value="+2 hours" <?php echo $selected; ?>>(GMT +2.00) Kaliningrad, South Africa</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+3 hours') ? 'selected' : ''; ?>
                <option value="+3 hours" <?php echo $selected; ?>>(GMT +3.00) Baghdad, Riyadh, Moscow, St. Petersburg</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+3 hours +30 minutes') ? 'selected' : ''; ?>
                <option value="+3 hours +30 minutes" <?php echo $selected; ?>>(GMT +3.30) Tehran</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+4 hours') ? 'selected' : ''; ?>
                <option value="+4 hours" <?php echo $selected; ?>>(GMT +4.00) Abu Dhabi, Muscat, Baku, Tbilisi</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+4 hours +30 minutes') ? 'selected' : ''; ?>
                <option value="+4 hours +30 minutes" <?php echo $selected; ?>>(GMT +4.30) Kabul</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+5 hours') ? 'selected' : ''; ?>
                <option value="+5 hours" <?php echo $selected; ?>>(GMT +5.00) Ekaterinburg, Islamabad, Karachi, Tashkent</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+5 hours +30 minutes') ? 'selected' : ''; ?>
                <option value="+5 hours +30 minutes" <?php echo $selected; ?>>(GMT +5.30) Bombay, Calcutta, Madras, New Delhi</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+5 hours +45 minutes') ? 'selected' : ''; ?>
                <option value="+5 hours +45 minutes" <?php echo $selected; ?>>(GMT +5.45) Kathmandu, Pokhara</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+6 hours') ? 'selected' : ''; ?>
                <option value="+6 hours" <?php echo $selected; ?>>(GMT +6.00) Almaty, Dhaka, Colombo</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+6 hours +30 minutes') ? 'selected' : ''; ?>
                <option value="+6 hours +30 minutes" <?php echo $selected; ?>>(GMT +6.30) Yangon, Mandalay</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+7 hours') ? 'selected' : ''; ?>
                <option value="+7 hours" <?php echo $selected; ?>>(GMT +7.00) Bangkok, Hanoi, Jakarta</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+8 hours') ? 'selected' : ''; ?>
                <option value="+8 hours" <?php echo $selected; ?>>(GMT +8.00) Beijing, Perth, Singapore, Hong Kong</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+8 hours +45 minutes') ? 'selected' : ''; ?>
                <option value="+8 hours +45 minutes" <?php echo $selected; ?>>(GMT +8.45) Eucla</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+9 hours') ? 'selected' : ''; ?>
                <option value="+9 hours" <?php echo $selected; ?>>(GMT +9.00) Tokyo, Seoul, Osaka, Sapporo, Yakutsk</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+9 hours +30 minutes') ? 'selected' : ''; ?>
                <option value="+9 hours +30 minutes" <?php echo $selected; ?>>(GMT +9.30) Adelaide, Darwin</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+10 hours') ? 'selected' : ''; ?>
                <option value="+10 hours" <?php echo $selected; ?>>(GMT +10.00) Eastern Australia, Guam, Vladivostok</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+10 hours +30 minutes') ? 'selected' : ''; ?>
                <option value="+10 hours +30 minutes" <?php echo $selected; ?>>(GMT +10.30) Lord Howe Island</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+11 hours') ? 'selected' : ''; ?>
                <option value="+11 hours" <?php echo $selected; ?>>(GMT +11.00) Magadan, Solomon Islands, New Caledonia</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+11 hours +30 minutes') ? 'selected' : ''; ?>
                <option value="+11 hours +30 minutes" <?php echo $selected; ?>>(GMT +11.30) Norfolk Island</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+12 hours') ? 'selected' : ''; ?>
                <option value="+12 hours" <?php echo $selected; ?>>(GMT +12.00) Auckland, Wellington, Fiji, Kamchatka</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+12 hours +45 minutes') ? 'selected' : ''; ?>
                <option value="+12 hours +45 minutes" <?php echo $selected; ?>>(GMT +12.45) Chatham Islands</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+13 hours') ? 'selected' : ''; ?>
                <option value="+13 hours" <?php echo $selected; ?>>(GMT +13.00) Apia, Nukualofa</option>
                <?php $selected = (isset($this->daily_readings_options['time_zone_7']) && $this->daily_readings_options['time_zone_7'] === '+14 hours') ? 'selected' : ''; ?>
                <option value="+14 hours" <?php echo $selected; ?>>(GMT +14.00) Line Islands, Tokelau</option>
            </select> 

            <br><p><i><?php _e('The plugin auto-detects your server time-zone, but you can select a different one if you need', 'daily-readings') ?></i></p>
        <?php
    }

}

if (is_admin()) $daily_readings = new DailyReadings();

?>
