<?php
/**
 * The testimonial Metabox  configuration.
 *
 * @link https://shapedplugin.com
 * @since 2.0.0
 *
 * @package Testimonial_free
 * @subpackage Testimonial_free/admin/views
 */

use ShapedPlugin\TestimonialFree\Admin\Views\Framework\Classes\SPFTESTIMONIAL;

if ( ! defined( 'ABSPATH' ) ) {
	die; } // Cannot access directly.



/**
 * Shortcode metabox.
 *
 * @param string $prefix The metabox main Key.
 * @return void
 */
SPFTESTIMONIAL::createMetabox(
	'sp_tpro_shortcode_show',
	array(
		'title'             => __( 'How To Use', 'testimonial-free' ),
		'post_type'         => 'spt_shortcodes',
		'context'           => 'side',
		'show_restore'      => false,
		'sp_tpro_shortcode' => false,
	)
);
SPFTESTIMONIAL::createSection(
	'sp_tpro_shortcode_show',
	array(
		'fields' => array(
			array(
				'type'      => 'shortcode',
				'shortcode' => 'manage_view',
				'class'     => 'sp_tpro-admin-sidebar',
			),
		),
	)
);
SPFTESTIMONIAL::createMetabox(
	'sp_tpro_builder_option',
	array(
		'title'             => __( 'Page Builders', 'testimonial-free' ),
		'post_type'         => 'spt_shortcodes',
		'context'           => 'side',
		'show_restore'      => false,
		'sp_tpro_shortcode' => false,
	)
);
SPFTESTIMONIAL::createSection(
	'sp_tpro_builder_option',
	array(
		'fields' => array(
			array(
				'type'      => 'shortcode',
				'shortcode' => false,
				'class'     => 'sp_tpro-admin-sidebar',
			),
		),
	)
);

SPFTESTIMONIAL::createMetabox(
	'sp_tpro_layout_options',
	array(
		'title'             => __( 'Layout', 'testimonial-free' ),
		'post_type'         => 'spt_shortcodes',
		'show_restore'      => false,
		'sp_tpro_shortcode' => false,
		'context'           => 'normal',
		'preview'           => true,
	)
);
SPFTESTIMONIAL::createSection(
	'sp_tpro_layout_options',
	array(
		'fields' => array(
			array(
				'type'    => 'heading',
				'image'   => esc_url( SP_TFREE_URL ) . '/Admin/assets/images/real-testimonials-logo.svg',
				'after'   => '<i class="fa fa-life-ring"></i> Support',
				'link'    => 'https://shapedplugin.com/support/?user=lite',
				'class'   => 'spftestimonial-admin-header',
				'version' => SP_TFREE_VERSION,
			),
			array(
				'id'      => 'layout',
				'type'    => 'image_select',
				'title'   => __( 'Layout Preset', 'testimonial-free' ),
				'class'   => 'tfree-layout-preset',
				'options' => array(
					'slider'           => array(
						'image'           => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/layouts/slider.svg',
						'name'            => __( 'Slider', 'testimonial-free' ),
						'option_demo_url' => 'https://realtestimonials.io/demos/slider/',
					),
					'carousel'         => array(
						'image'           => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/layouts/carousel.svg',
						'name'            => __( 'Carousel', 'testimonial-free' ),
						'option_demo_url' => 'https://realtestimonials.io/demos/carousel/',
					),
					'grid'             => array(
						'image'           => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/layouts/grid.svg',
						'name'            => __( 'Grid', 'testimonial-free' ),
						'option_demo_url' => 'https://realtestimonials.io/demos/grid/',
					),
					'thumbnail_slider' => array(
						'image'           => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/layouts/thumbnails_slider.svg',
						'name'            => __( 'Thumbnails Slider', 'testimonial-free' ),
						'option_demo_url' => 'https://realtestimonials.io/demos/thumbnails-slider/',
						'pro_only'        => true,
						'class'           => 'pro-feature',
					),
					'multi_rows'       => array(
						'image'           => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/carousel-mode/multi_rows.svg',
						'name'            => __( 'Multi-row', 'testimonial-free' ),
						'option_demo_url' => 'https://realtestimonials.io/demos/carousel/#multi-rows-carousel',
						'pro_only'        => true,
						'class'           => 'pro-feature',
					),
					'masonry'          => array(
						'image'           => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/layouts/filter_masonry.svg',
						'name'            => __( 'Masonry', 'testimonial-free' ),
						'option_demo_url' => 'https://realtestimonials.io/demos/masonry/',
						'pro_only'        => true,
						'class'           => 'pro-feature',
					),
					'list'             => array(
						'image'           => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/layouts/list.svg',
						'name'            => __( 'List', 'testimonial-free' ),
						'option_demo_url' => 'https://realtestimonials.io/demos/list/',
						'pro_only'        => true,
						'class'           => 'pro-feature',
					),
					'filter'           => array(
						'image'           => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/layouts/isotope.svg',
						'name'            => __( 'Isotope', 'testimonial-free' ),
						'option_demo_url' => 'https://realtestimonials.io/demos/isotope-shuffle-filter/',
						'pro_only'        => true,
						'class'           => 'pro-feature',
					),
				),
				'default' => 'slider',
			),
			array(
				'id'         => 'carousel_mode',
				'type'       => 'image_select',
				'class'      => 'sp_carousel_mode',
				'title'      => __( 'Carousel Style', 'testimonial-free' ),
				'options'    => array(
					'standard' => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/carousel-mode/standard.svg',
						'name'  => __( 'Standard', 'testimonial-free' ),
					),
					'center'   => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/carousel-mode/center.svg',
						'name'  => __( 'Center', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'ticker'   => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/carousel-mode/slider_ticker.svg',
						'name'  => __( 'Ticker', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
				),
				'default'    => 'standard',
				'dependency' => array( 'layout', '==', 'carousel', true ),
			),
			array(
				'id'         => 'theme_style_thumbnail',
				'type'       => 'image_select',
				'class'      => 'sp_carousel_mode',
				'title'      => __( 'Thumbnails Style', 'testimonial-free' ),
				'options'    => array(
					'theme-one'   => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/thumbnail-style/thumbs_top.svg',
						'name'  => __( 'Thumbs Top', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-two'   => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/thumbnail-style/thumbs_bottom.svg',
						'name'  => __( 'Thumbs Bottom', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-three' => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/thumbnail-style/thumbs_left.svg',
						'name'  => __( 'Thumbs Left', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-four'  => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/thumbnail-style/thumbs_right.svg',
						'name'  => __( 'Thumbs Right', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
				),
				'default'    => 'theme-one',
				'dependency' => array( 'layout', '==', 'thumbnail_slider', true ),
			),
			array(
				'id'         => 'filter_style',
				'class'      => 'filter_style sp_carousel_mode',
				'type'       => 'image_select',
				'title'      => __( 'Isotope Style', 'testimonial-free' ),
				'options'    => array(
					'even'    => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/layouts/grid_even.svg',
						'name'  => __( 'Even', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'masonry' => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/layouts/masonry.svg',
						'name'  => __( 'Masonry', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
				),
				'default'    => 'even',
				'dependency' => array(
					'layout',
					'==',
					'filter',
					true,
				),
			),
			array(
				'type'    => 'notice',
				'class'   => 'ajax-notice layout',
				'content' => sprintf(
					/* translators: 1: start link tag, 2: close tag. */
					__( 'To create eye-catching testimonial layout designs and access to advanced customizations, %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
					'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
					'</b></a>',
				),
			),
		),
	)
);

//
// Metabox of the testimonial shortcode generator.
// Set a unique slug-like ID.
//
$prefix_shortcode_opts = 'sp_tpro_shortcode_options';

//
// Real Testimonials metabox.
//
SPFTESTIMONIAL::createMetabox(
	$prefix_shortcode_opts,
	array(
		'title'     => __( 'Shortcode Options', 'testimonial-free' ),
		'class'     => 'spt-main-class',
		'post_type' => 'spt_shortcodes',
		'context'   => 'normal',
	)
);
//
// General Settings section.
//
SPFTESTIMONIAL::createSection(
	$prefix_shortcode_opts,
	array(
		'title'  => __( 'General Settings', 'testimonial-free' ),
		'icon'   => 'sptfree-icon-cog',
		'fields' => array(
			array(
				'id'       => 'columns',
				'type'     => 'column',
				'title'    => __( 'Columns', 'testimonial-free' ),
				'subtitle' => __( 'Set number of columns in different devices.', 'testimonial-free' ),
				'sanitize' => 'spftestimonial_sanitize_number_array_field',
				'default'  => array(
					'large_desktop' => '1',
					'desktop'       => '1',
					'laptop'        => '1',
					'tablet'        => '1',
					'mobile'        => '1',
				),
			),
			array(
				'id'         => 'testimonial_margin',
				'class'      => 'testimonial-slide-margin',
				'type'       => 'spacing',
				'title'      => __( 'Space', 'testimonial-free' ),
				'subtitle'   => __( 'Set space between the testimonials.', 'testimonial-free' ),
				'title_help' => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/space.svg" alt="' . __( 'Space Between Testimonials', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Space Between Testimonials', 'testimonial-free' ) . '</div>',
				'right'      => true,
				'top'        => true,
				'left'       => false,
				'bottom'     => false,
				'right_text' => 'Vertical Gap',
				'top_text'   => 'Gap',
				'right_icon' => '<i class="fa fa-arrows-v"></i>',
				'top_icon'   => '<i class="fa fa-arrows-h"></i>',
				'unit'       => true,
				'units'      => array( 'px' ),
				'default'    => array(
					'top'   => '20',
					'right' => '20',
				),
			),
			array(
				'id'       => 'display_testimonials_from',
				'type'     => 'select_f',
				'title'    => __( 'Filter Testimonials', 'testimonial-free' ),
				'subtitle' => __( 'Select an option to display the testimonials.', 'testimonial-free' ),
				'sanitize' => 'sanitize_text_field',
				'options'  => array(
					'latest'                => array(
						'name'     => __( 'Latest', 'testimonial-free' ),
						'pro_only' => false,
					),
					'category'              => array(
						'name'     => __( 'Groups (Pro)', 'testimonial-free' ),
						'pro_only' => true,
					),
					'specific_testimonials' => array(
						'name'     => __( 'Specific (Pro)', 'testimonial-free' ),
						'pro_only' => true,
					),
					'exclude'               => array(
						'name'     => __( 'Exclude (Pro)', 'testimonial-free' ),
						'pro_only' => true,
					),
					'based_on_rating_star'  => array(
						'name'     => __( 'Based on Star Rating (Pro)', 'testimonial-free' ),
						'pro_only' => true,
					),
				),
				'default'  => 'latest',
			),
			array(
				'id'       => 'number_of_total_testimonials',
				'type'     => 'spinner',
				'title'    => __( 'Limit', 'testimonial-free' ),
				'subtitle' => __( 'Leave it empty to show all testimonials.', 'testimonial-free' ),
				'default'  => '12',
				'sanitize' => 'spftestimonial_sanitize_number_field',
				'min'      => -1,
			),
			array(
				'id'         => 'random_order',
				'type'       => 'switcher',
				'class'      => 'pro_switcher',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Random Order', 'testimonial-free' ),
				'subtitle'   => __( 'Enable to display testimonials in random order.', 'testimonial-free' ),
				'text_on'    => __( 'Enabled', 'testimonial-free' ),
				'text_off'   => __( 'Disabled', 'testimonial-free' ),
				'text_width' => 100,
				'default'    => false,
				'sanitize'   => 'rest_sanitize_boolean',
			),
			array(
				'id'       => 'testimonial_order_by',
				'type'     => 'select_f',
				'title'    => __( 'Order By', 'testimonial-free' ),
				'subtitle' => __( 'Select an order by option.', 'testimonial-free' ),
				'options'  => array(
					'ID'         => array(
						'name'     => __( 'Testimonial ID', 'testimonial-free' ),
						'pro_only' => false,
					),
					'date'       => array(
						'name'     => __( 'Date', 'testimonial-free' ),
						'pro_only' => false,
					),
					'title'      => array(
						'name'     => __( 'Title', 'testimonial-free' ),
						'pro_only' => false,
					),
					'modified'   => array(
						'name'     => __( 'Modified', 'testimonial-free' ),
						'pro_only' => false,
					),
					'menu_order' => array(
						'name'     => __( 'Drag & Drop (Pro)', 'testimonial-free' ),
						'pro_only' => true,
					),
				),
				'sanitize' => 'sanitize_text_field',
				'default'  => 'date',
			),
			array(
				'id'       => 'testimonial_order',
				'type'     => 'select',
				'title'    => __( 'Order Type', 'testimonial-free' ),
				'subtitle' => __( 'Select an order option.', 'testimonial-free' ),
				'options'  => array(
					'ASC'  => __( 'Ascending', 'testimonial-free' ),
					'DESC' => __( 'Descending', 'testimonial-free' ),
				),
				'default'  => 'DESC',
				'sanitize' => 'sanitize_text_field',
			),
			array(
				'id'         => 'ajax_live_filter',
				'type'       => 'switcher',
				'title'      => __( 'Ajax Live Filters', 'testimonial-free' ),
				'class'      => 'testimonial-live-filter',
				'sanitize'   => 'rest_sanitize_boolean',
				'subtitle'   => __( 'Enable the Ajax Live Filters by groups or star ratings.', 'testimonial-free' ),
				'title_help' => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/ajax_live_filter.svg" alt="' . __( 'Ajax Live Filter', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Ajax Live Filter (Pro)', 'testimonial-free' ) . '</div><a class="spftestimonial-open-live-demo" href="https://realtestimonials.io/demos/advanced-ajax-features/" target="_blank">' . __( 'Live Demo', 'testimonial-free' ) . '</a>',
				'text_on'    => __( 'Enabled', 'testimonial-free' ),
				'text_off'   => __( 'Disabled', 'testimonial-free' ),
				'text_width' => 100,
				'only_pro'   => true,
				'default'    => false,
			),
			array(
				'type'       => 'subheading',
				'content'    => __( 'AJAX LIVE FILTERS', 'testimonial-free' ),
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'type'       => 'notice',
				'class'      => 'ajax-notice',
				'content'    => sprintf(
					/* translators: 1: start link tag, 2: close tag. */
					__( 'To allow your visitors to filter reviews by %3$sGroups%2$s, %4$sStar Ratings%2$s, Ajax Search, and Sort on the frontend, %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
					'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
					'</b></a>',
					'<a target="_blank" href="https://realtestimonials.io/demos/advanced-ajax-features/#group-wise-live-filter-carousel"><b>',
					'<a target="_blank" href="https://realtestimonials.io/demos/advanced-ajax-features/#live-filter-by-star-rating"><b>',
				),
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'live_filter_sorter',
				'type'       => 'sortable',
				'title'      => __( 'Filter By', 'testimonial-free' ),
				'subtitle'   => __( 'Enable your filter(s).', 'testimonial-free' ),
				'class'      => 'live_filter_sorter',
				'only_pro'   => true,
				'default'    => array(
					'filter_by_star_rating' => true,
					'filter_by_group'       => true,
				),
				'fields'     => array(
					array(
						'id'         => 'filter_by_star_rating',
						'type'       => 'switcher',
						'title'      => __( 'Star Rating', 'testimonial-free' ),
						'text_on'    => __( 'Show', 'testimonial-free' ),
						'text_off'   => __( 'Hide', 'testimonial-free' ),
						'text_width' => 80,
						'only_pro'   => true,
						'class'      => 'pro_switcher',
					),
					array(
						'id'         => 'filter_by_group',
						'type'       => 'switcher',
						'title'      => __( 'Groups', 'testimonial-free' ),
						'text_on'    => __( 'Show', 'testimonial-free' ),
						'text_off'   => __( 'Hide', 'testimonial-free' ),
						'text_width' => 80,
						'only_pro'   => true,
						'class'      => 'pro_switcher',

					),
				),
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'live_filter_type',
				'type'       => 'image_select',
				'class'      => 'live_filter_type sp-testimonial-live-filters-options',
				'title'      => __( 'Filter Style', 'testimonial-free' ),
				'subtitle'   => __( 'Choose a filter style.', 'testimonial-free' ),
				'options'    => array(
					'filter_button'   => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/filter-button.svg',
						'name'  => __( 'Button', 'testimonial-free' ),
					),
					'filter_dropdown' => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/filter-dropdown.svg',
						'name'  => __( 'Dropdown', 'testimonial-free' ),
					),
				),
				'only_pro'   => true,
				'default'    => 'filter_button',
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'filter_ratings_label_type',
				'type'       => 'image_select',
				'class'      => 'filter_ratings_label_type sp-testimonial-live-filters-options',
				'title'      => __( 'Star Rating Label Style', 'testimonial-free' ),
				'subtitle'   => __( 'Select a star rating label style.', 'testimonial-free' ),
				'only_pro'   => true,
				'options'    => array(
					'text'           => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-style/text-r.svg',
						'name'  => __( 'Label', 'testimonial-free' ),
					),
					'icon'           => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-style/icon-r.svg',
						'name'  => __( 'Star', 'testimonial-free' ),
					),
					'text_with_icon' => array(
						'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-style/text-icon-r.svg',
						'name'  => __( 'Label with Star', 'testimonial-free' ),
					),
				),
				'default'    => 'text',
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'star_rating_filter_as_dropdown',
				'type'       => 'switcher',
				'class'      => 'pro_switcher',
				'title'      => __( 'Star Rating Filter as Dropdown', 'testimonial-free' ),
				'subtitle'   => __( 'Enable the dropdown style.', 'testimonial-free' ),
				'text_on'    => __( 'Enabled', 'testimonial-free' ),
				'text_off'   => __( 'Disabled', 'testimonial-free' ),
				'only_pro'   => true,
				'text_width' => 100,
				'default'    => false,
				'title_help' => '<div class="spftestimonial-info-label">' . __( 'Star Rating Filter as Dropdown', 'testimonial-free' ) . '</div><div class="spftestimonial-short-content">' . __( 'When Enabled, the Star Rating filter will appear as a dropdown along with the button-styled Group filter.', 'testimonial-free' ) . '</div><a class="spftestimonial-open-live-demo" href="https://realtestimonials.io/demos/advanced-ajax-features/#star-rating-filter-as-dropdown" target="_blank">' . __( 'Live Demo', 'testimonial-free' ) . '</a>',
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'enable_inline_filter_style',
				'type'       => 'switcher',
				'class'      => 'enable_inline_filter_style pro_switcher',
				'title'      => __( 'Inline Filter Style', 'testimonial-free' ),
				'subtitle'   => __( 'Enable the testimonial inline filter style.', 'testimonial-free' ),
				'text_on'    => __( 'Enabled', 'testimonial-free' ),
				'text_off'   => __( 'Disabled', 'testimonial-free' ),
				'text_width' => 100,
				'default'    => false,
				'only_pro'   => true,
				'title_help' => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/inline_filter_style.svg" alt="' . __( 'AInline Filter Style', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Inline Filter Style (Pro)', 'testimonial-free' ) . '</div><div class="spftestimonial-short-content">' . __( 'When Enabled, It will show the Group and Star Rating filters in inline style; when disabled, it will show the filters in horizontal style.', 'testimonial-free' ) . '</div><a class="spftestimonial-open-live-demo" href="https://realtestimonials.io/demos/advanced-ajax-features/#live-filter-inline-style" target="_blank">' . __( 'Live Demo', 'testimonial-free' ) . '</a>',
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'filter_by_rating_orientation',
				'type'       => 'button_set',
				'class'      => 'sp-testimonial-live-filters-options',
				'title'      => __( 'Star Rating Filter Orientation', 'testimonial-free' ),
				'subtitle'   => __( 'Choose a star rating filter orientation, whether horizontal or vertical.', 'testimonial-free' ),
				'options'    => array(
					'horizontal' => 'Horizontal',
					'vertical'   => 'Vertical',
				),
				'only_pro'   => true,
				'default'    => 'horizontal',
				'title_help' => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/star_rating_filter_orientation.svg" alt="' . __( 'Star Rating Filter Orientation', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Star Rating Filter Orientation (Pro)', 'testimonial-free' ) . '</div><div class="spftestimonial-short-content">' . __( 'For the vertical style, when the average rating section is enabled with the rating star filter, the rating star filter will show as a side-by-side view.', 'testimonial-free' ) . '</div><a class="spftestimonial-open-live-demo" href="https://realtestimonials.io/demos/advanced-ajax-features/#live-filter-by-star-rating" target="_blank">' . __( 'Live Demo', 'testimonial-free' ) . '</a>',
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'filter_testimonials_counter',
				'type'       => 'switcher',
				'class'      => 'pro_switcher',
				'title'      => __( 'Counter', 'testimonial-free' ),
				'subtitle'   => __( 'Show/Hide testimonial counter.', 'testimonial-free' ),
				'text_on'    => __( 'Show', 'testimonial-free' ),
				'text_off'   => __( 'Hide', 'testimonial-free' ),
				'text_width' => 80,
				'default'    => false,
				'only_pro'   => true,
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'all_tab',
				'type'       => 'switcher',
				'class'      => 'pro_switcher',
				'title'      => __( 'Display All Tab', 'testimonial-free' ),
				'subtitle'   => __( 'Show/Hide "All" tab.', 'testimonial-free' ),
				'text_on'    => __( 'Show', 'testimonial-free' ),
				'text_off'   => __( 'Hide', 'testimonial-free' ),
				'text_width' => 80,
				'default'    => true,
				'only_pro'   => true,
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'all_tab_text',
				'type'       => 'text',
				'class'      => 'all_tab_text sp-testimonial-live-filters-options',
				'title'      => __( 'All Tab Label', 'testimonial-free' ),
				'subtitle'   => __( 'Set "All" tab label text.', 'testimonial-free' ),
				'default'    => 'All',
				'only_pro'   => true,
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'filter_alignment',
				'type'       => 'button_set',
				'class'      => 'button_set_smaller sp-testimonial-live-filters-options',
				'title'      => __( 'Button Alignment', 'testimonial-free' ),
				'subtitle'   => __( 'Set alignment for filter button.', 'testimonial-free' ),
				'options'    => array(
					'left'   => '<i class="fa fa-align-left" title="left"></i>',
					'center' => '<i class="fa fa-align-center" title="center"></i>',
					'right'  => '<i class="fa fa-align-right" title="right"></i>',
				),
				'only_pro'   => true,
				'default'    => 'center',
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'         => 'filter_colors',
				'type'       => 'color_group',
				'class'      => 'sp-testimonial-live-filters-options',
				'title'      => __( 'Filter Button Color', 'testimonial-free' ),
				'subtitle'   => __( 'Set color for filter button.', 'testimonial-free' ),
				'options'    => array(
					'color'             => __( 'Color', 'testimonial-free' ),
					'active-color'      => __( 'Active Color', 'testimonial-free' ),
					'background'        => __( 'Background', 'testimonial-free' ),
					'active-background' => __( 'Active Background', 'testimonial-free' ),
				),
				'default'    => array(
					'color'             => '#7e7e7e',
					'active-color'      => '#ffffff',
					'background'        => '#ffffff',
					'active-background' => '#1595CE',
				),
				'only_pro'   => true,
				'dependency' => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'          => 'filter_border',
				'type'        => 'border',
				'title'       => __( 'Border', 'testimonial-free' ),
				'class'       => 'sp-testimonial-live-filters-options',
				'subtitle'    => __( 'Set border for the filter button.', 'testimonial-free' ),
				'all'         => true,
				'hover_color' => true,
				'default'     => array(
					'all'         => '2',
					'style'       => 'solid',
					'color'       => '#aeaeae',
					'hover-color' => '#1595CE',
				),
				'only_pro'    => true,
				'dependency'  => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'id'          => 'filter_margin',
				'type'        => 'spacing',
				'title'       => __( 'Margin', 'testimonial-free' ),
				'class'       => 'sp-testimonial-live-filters-options',
				'subtitle'    => __( 'Set margin for filter.', 'testimonial-free' ),
				'default'     => array(
					'top'    => '0',
					'right'  => '0',
					'bottom' => '24',
					'left'   => '0',
					'unit'   => 'px',
				),
				'top_text'    => __( 'Top', 'testimonial-free' ),
				'right_text'  => __( 'Right', 'testimonial-free' ),
				'bottom_text' => __( 'Bottom', 'testimonial-free' ),
				'left_text'   => __( 'Left', 'testimonial-free' ),
				'units'       => array( 'px' ),
				'only_pro'    => true,
				'dependency'  => array( 'ajax_live_filter|layout', '==|not-any', 'true|filter,thumbnail_slider', true ),
			),
			array(
				'type'       => 'subheading',
				'content'    => __( 'LOAD MORE PAGINATION', 'testimonial-free' ),
				'dependency' => array(
					'layout',
					'==',
					'grid',
					true,
				),
			),
			array(
				'type'       => 'notice',
				'class'      => 'sp_testimonial-pagination-notice',
				'style'      => 'info',
				'content'    => sprintf(
					/* translators: 1: start link tag, 2: close tag. */
					__( 'To unlock the following ajax pagination settings for Grid, Masonry, & List layouts, %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
					'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
					'</b></a>',
				),
				'dependency' => array(
					'layout',
					'==',
					'grid',
					true,
				),
			),
			array(
				'id'         => 'grid_pagination',
				'type'       => 'switcher',
				'title'      => __( 'Pagination', 'testimonial-free' ),
				'subtitle'   => __( 'Enqueue/Dequeue pagination.', 'testimonial-free' ),
				'text_on'    => __( 'Enable', 'testimonial-free' ),
				'text_off'   => __( 'Disable', 'testimonial-free' ),
				'text_width' => 100,
				'default'    => true,
				'sanitize'   => 'rest_sanitize_boolean',
				'dependency' => array(
					'layout',
					'==',
					'grid',
					true,
				),
			),
			array(
				'id'         => 'tp_pagination_type',
				'type'       => 'radio',
				'title'      => __( 'Pagination Type', 'testimonial-free' ),
				'subtitle'   => __( 'Choose a pagination type.', 'testimonial-free' ),
				'options'    => array(
					'ajax_load_more'  => __( 'Ajax Load More Button (Pro)', 'testimonial-free' ),
					'ajax_pagination' => __( 'Ajax Number Pagination (Pro)', 'testimonial-free' ),
					'infinite_scroll' => __( 'Ajax Infinite Scroll (Pro)', 'testimonial-free' ),
					'no_ajax'         => __( 'No Ajax (Normal Pagination)', 'testimonial-free' ),
				),
				'default'    => 'no_ajax',
				'sanitize'   => 'sanitize_text_field',
				'dependency' => array(
					'layout|grid_pagination',
					'==|==',
					'grid|true',
					true,
				),
			),
			array(
				'id'         => 'tp_per_page',
				'type'       => 'spinner',
				'title'      => __( 'Testimonial(s) to Show Per Page', 'testimonial-free' ),
				'subtitle'   => __( 'Set number of testimonial(s) to show per page.', 'testimonial-free' ),
				'sanitize'   => 'spftestimonial_sanitize_number_field',
				'default'    => 8,
				'dependency' => array(
					'layout|grid_pagination',
					'==|==',
					'grid|true',
					true,
				),
			),
			array(
				'id'         => 'grid_pagination_alignment',
				'type'       => 'button_set',
				'class'      => 'button_set_smaller',
				'title'      => __( 'Alignment', 'testimonial-free' ),
				'subtitle'   => __( 'Select pagination alignment.', 'testimonial-free' ),
				'options'    => array(
					'left'   => '<i class="fa fa-align-left" title="left"></i>',
					'center' => '<i class="fa fa-align-center" title="center"></i>',
					'right'  => '<i class="fa fa-align-right" title="right"></i>',
				),
				'default'    => 'left',
				'sanitize'   => 'sanitize_text_field',
				'dependency' => array(
					'layout|grid_pagination',
					'==|==',
					'grid|true',
					true,
				),
			),
			array(
				'id'         => 'grid_pagination_margin',
				'type'       => 'spacing',
				'title'      => __( 'Margin', 'testimonial-free' ),
				'subtitle'   => __( 'Set pagination margin.', 'testimonial-free' ),
				'sanitize'   => 'spftestimonial_sanitize_number_array_field',
				'default'    => array(
					'top'    => '20',
					'right'  => '0',
					'bottom' => '20',
					'left'   => '0',
					'unit'   => 'px',
				),
				'units'      => array( 'px' ),
				'dependency' => array(
					'layout|grid_pagination',
					'==|==',
					'grid|true',
					true,
				),
			),
			array(
				'id'         => 'grid_pagination_colors',
				'type'       => 'color_group',
				'title'      => __( 'Pagination Color', 'testimonial-free' ),
				'subtitle'   => __( 'Set color for pagination.', 'testimonial-free' ),
				'sanitize'   => 'spftestimonial_sanitize_color_group_field',
				'options'    => array(
					'color'            => __( 'Color', 'testimonial-free' ),
					'hover-color'      => __( 'Hover Color', 'testimonial-free' ),
					'background'       => __( 'Background', 'testimonial-free' ),
					'hover-background' => __( 'Hover Background', 'testimonial-free' ),
				),
				'default'    => array(
					'color'            => '#5e5e5e',
					'hover-color'      => '#ffffff',
					'background'       => '#ffffff',
					'hover-background' => '#1595CE',
				),
				'dependency' => array(
					'layout|grid_pagination',
					'==|==',
					'grid|true',
					true,
				),
			),
			array(
				'id'          => 'grid_pagination_border',
				'type'        => 'border',
				'title'       => __( 'Pagination Border', 'testimonial-free' ),
				'subtitle'    => __( 'Set pagination border.', 'testimonial-free' ),
				'sanitize'    => 'spftestimonial_sanitize_border_field',
				'all'         => true,
				'hover_color' => true,
				'default'     => array(
					'all'         => '2',
					'style'       => 'solid',
					'color'       => '#bbbbbb',
					'hover-color' => '#1595CE',
				),
				'dependency'  => array(
					'layout|grid_pagination',
					'==|==',
					'grid|true',
					true,
				),
			),

		),
	)
);
// Theme settings.
SPFTESTIMONIAL::createSection(
	$prefix_shortcode_opts,
	array(
		'title'  => __( 'Theme Settings', 'testimonial-free' ),
		'icon'   => 'sptfree-icon-theme-styles',
		'fields' => array(
			array(
				'type'    => 'notice',
				'class'   => 'theme-settings-top-notice',
				'content' => sprintf(
					/* translators: 1: start link tag, 2: close tag. */
					__( 'To impress your potential customers with professionally designed testimonial themes/templates, %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
					'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
					'</b></a>',
				),
			),
			array(
				'id'       => 'theme_style',
				'class'    => 'theme_style',
				'type'     => 'image_select',
				'title'    => __( 'Select Your Theme', 'testimonial-free' ),
				'subtitle' => sprintf(
					/* translators: 1: start bold tag, 2: close tag. */
					__( 'Select which theme style you want to use. %1$sPlease note:%2$s To get the perfect view for certain themes, you need to configure some settings below.', 'testimonial-free' ),
					'<b>',
					'</b>',
				),
				'desc'     => sprintf(
					/* translators: 1: start link tag, 2: close tag. */
					__( 'Get Access to 14 Professionally Designed Testimonial Themes with Customization options, %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
					'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
					'</b></a>',
				),
				'sanitize' => 'sanitize_text_field',
				'options'  => array(
					'theme-one'         => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_one.svg',
						'name'  => __( 'Theme One', 'testimonial-free' ),
					),
					'theme-two'         => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_two.svg',
						'name'  => __( 'Theme Two', 'testimonial-free' ),
						'class' => 'pro-feature',
					),

					'theme-three'       => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_three.svg',
						'name'  => __( 'Theme Three', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-four'        => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_four.svg',
						'name'  => __( 'Theme Four', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-five'        => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_four.svg',
						'name'  => __( 'Theme Five', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-six'         => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_five.svg',
						'name'  => __( 'Theme Six', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-seven'       => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_seven.svg',
						'name'  => __( 'Theme Seven', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-eight'       => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_eight.svg',
						'name'  => __( 'Theme Eight', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-nine'        => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_nine.svg',
						'name'  => __( 'Theme Nine', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'theme-ten'         => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/theme_ten.svg',
						'name'  => __( 'Theme Ten', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'thumb-theme-one'   => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/thumb_theme_one.svg',
						'name'  => __( 'Theme Eleven', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'thumb-theme-two'   => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/thumb_theme_two.svg',
						'name'  => __( 'Theme Twelve', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'thumb-theme-three' => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/thumb_theme_three.svg',
						'name'  => __( 'Theme Thirteen', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
					'thumb-theme-four'  => array(
						'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/theme-style/thumb_theme_four.svg',
						'name'  => __( 'Theme Fourteen', 'testimonial-free' ),
						'class' => 'pro-feature',
					),
				),
				'default'  => 'theme-one',
			),

			array(
				'type'    => 'subheading',
				'content' => __( 'CUSTOMIZE THEME', 'testimonial-free' ),
			),
			array(
				'id'       => 'client_image_position',
				'type'     => 'button_set',
				'class'    => 'button_set_smaller',
				'title'    => __( 'Reviewer Image Alignment', 'testimonial-free' ),
				'subtitle' => __( 'Set an alignment for the reviewer image.', 'testimonial-free' ),
				'options'  => array(
					'left'   => '<i class="fa fa-align-left" title="left"></i>',
					'center' => '<i class="fa fa-align-center" title="center"></i>',
					'right'  => '<i class="fa fa-align-right" title="right"></i>',
				),
				'default'  => 'center',
			),
			array(
				'id'       => 'testimonial_border_for_one',
				'type'     => 'border',
				'title'    => __( 'Border', 'testimonial-free' ),
				'subtitle' => __( 'Set testimonial border.', 'testimonial-free' ),
				'sanitize' => 'spftestimonial_sanitize_border_field',
				'all'      => true,
				'radius'   => true,
				'default'  => array(
					'all'    => '0',
					'style'  => 'solid',
					'color'  => '#e3e3e3',
					'radius' => '0',
				),
			),
			array(
				'id'       => 'background_color_type',
				'type'     => 'button_set',
				'title'    => __( 'Background Color Type', 'testimonial-free' ),
				'subtitle' => __( 'Choose background color type.', 'testimonial-free' ),
				'options'  => array(
					'solid'    => 'Solid',
					'gradient' => array(
						'option_name' => __( 'Gradient', 'testimonial-free' ),
						'pro_only'    => true,
					),
				),
				'default'  => 'solid',
			),
			array(
				'id'       => 'testimonial_bg_for_one',
				'type'     => 'color',
				'title'    => __( 'Background', 'testimonial-free' ),
				'subtitle' => __( 'Set testimonial background color.', 'testimonial-free' ),
				'default'  => 'transparent',
				'sanitize' => 'sanitize_text_field',
			),
			array(
				'type'    => 'notice',
				'content' => sprintf(
					/* translators: 1: start link tag, 2: close tag. */
					__( 'To unlock the Testimonial Theme-based Advanced Customization options, %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
					'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
					'</b></a>',
				),
			),
			array(
				'id'         => 'client_image_vertical_position',
				'type'       => 'select',
				'class'      => 'button_set_smaller pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Reviewer Image Position', 'testimonial-free' ),
				'subtitle'   => __( 'Select a position for the reviewer image.', 'testimonial-free' ),
				'options'    => array(
					'top'    => 'Top',
					'middle' => 'Middle',
					'bottom' => 'Bottom',
				),
				'default'    => 'top',
				'dependency' => array(
					'client_image|theme_style|slider_mode',
					'==|==|!=',
					'true|theme-one|thumbnail_slider',
					true,
				),
			),
			array(
				'id'         => 'testimonial_inner_padding',
				'type'       => 'spacing',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Inner Padding', 'testimonial-free' ),
				'subtitle'   => __( 'Set testimonial inner padding.', 'testimonial-free' ),
				'title_help' => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/inner_padding.svg" alt="' . __( 'Inner Padding', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Inner Padding', 'testimonial-free' ) . '</div>',
				'sanitize'   => 'spftestimonial_sanitize_number_array_field',
				'default'    => array(
					'top'    => '22',
					'right'  => '22',
					'bottom' => '22',
					'left'   => '22',
					'unit'   => 'px',
				),
				'units'      => array( 'px' ),
			),
			array(
				'id'         => 'testimonial_info_position',
				'type'       => 'button_set',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Info Position', 'testimonial-free' ),
				'subtitle'   => __( 'Select testimonial info position.', 'testimonial-free' ),
				'options'    => array(
					'top'    => __( 'Top', 'testimonial-free' ),
					'bottom' => __( 'Bottom', 'testimonial-free' ),
					'left'   => __( 'Left', 'testimonial-free' ),
					'right'  => __( 'Right', 'testimonial-free' ),
				),
				'default'    => 'bottom',
			),
			array(
				'id'         => 'testimonial_info_border',
				'type'       => 'border',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Info Border', 'testimonial-free' ),
				'subtitle'   => __( 'Set testimonial info border.', 'testimonial-free' ),
				'sanitize'   => 'spftestimonial_sanitize_border_field',
				'all'        => true,
				'default'    => array(
					'all'   => '0',
					'style' => 'solid',
					'color' => '#e3e3e3',
				),
			),
			array(
				'id'         => 'testimonial_info_bg',
				'type'       => 'color',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Testimonial Info Background', 'testimonial-free' ),
				'subtitle'   => __( 'Set background color for testimonial information.', 'testimonial-free' ),
				'default'    => '#f1e9e0',
				'sanitize'   => 'sanitize_text_field',
			),
			array(
				'id'         => 'testimonial_info_inner_padding',
				'type'       => 'spacing',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Testimonial Info Inner Padding', 'testimonial-free' ),
				'subtitle'   => __( 'Set inner padding for testimonial information.', 'testimonial-free' ),
				'sanitize'   => 'spftestimonial_sanitize_number_array_field',
				'default'    => array(
					'top'    => '22',
					'right'  => '22',
					'bottom' => '22',
					'left'   => '22',
					'unit'   => 'px',
				),
				'units'      => array( 'px' ),
			),
			array(
				'id'         => 'testimonial_same_height',
				'type'       => 'switcher',
				'class'      => 'pro_switcher',
				'title'      => __( 'Enable Equal Height', 'testimonial-free' ),
				'subtitle'   => __( 'Enable to adjust the height of all the testimonial items to match the tallest one.', 'testimonial-free' ),
				'title_help' => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/equalize_testimonials_height.svg" alt="' . __( 'Enable Equal Height', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Enable Equal Height', 'testimonial-free' ) . '</div>',
				'default'    => false,
				'text_on'    => __( 'Enabled', 'testimonial-free' ),
				'text_off'   => __( 'Disabled', 'testimonial-free' ),
				'text_width' => 100,
				'dependency' => array( 'layout', 'any', 'slider,carousel,grid', true ),
			),
		),
	)
);

//
// Display Settings section.
//
SPFTESTIMONIAL::createSection(
	$prefix_shortcode_opts,
	array(
		'title'  => __( 'Display Settings', 'testimonial-free' ),
		'icon'   => 'fa fa-th-large',
		'fields' => array(
			array(
				'type'  => 'tabbed',
				'class' => 'tabbed-inside-display-settings',
				'tabs'  => array(
					array(
						'title'  => __( 'Basic Preferences', 'testimonial-free' ),
						'icon'   => '<i class="testimonial--icon sptfree-icon-basic-preferences"></i>',
						'fields' => array(
							array(
								'id'         => 'section_title',
								'type'       => 'switcher',
								'title'      => __( 'Section Title', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide the testimonial section title.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => false,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'average_rating_top',
								'type'       => 'switcher',
								'title'      => __( 'Average Rating', 'testimonial-free' ),
								'class'      => 'pro_switcher',
								'subtitle'   => __( 'Show/Hide average rating.', 'testimonial-free' ),
								'title_help' => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/average_rating.svg" alt="' . __( 'Average Rating', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Average Rating', 'testimonial-free' ) . '</div>',
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => false,
							),
							array(
								'id'         => 'ajax_search',
								'type'       => 'switcher',
								'class'      => 'pro_switcher',
								'title'      => __( 'Ajax Testimonial Search', 'testimonial-free' ),
								'subtitle'   => __( 'Enable/Disable ajax search for testimonial.', 'testimonial-free' ),
								'title_help' => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/ajax_testimonial_search.svg" alt="' . __( 'Ajax Testimonial Search', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Ajax Testimonial Search', 'testimonial-free' ) . '</div>',
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'default'    => false,
								// 'dependency' => array( 'slider_mode', '!=', 'thumbnail_slider', true ),
							),

							array(
								'id'         => 'schema_markup',
								'type'       => 'switcher',
								'title'      => __( 'Schema Markup', 'testimonial-free' ),
								'title_help' => '<div class="spftestimonial-info-label schema-markup">' . __( 'Enable Schema.org Markup', 'testimonial-free' ) . '</div><div class="spftestimonial-short-content">' . __( 'Reviews Schema.org markup will let search engines read the reviews and overall ratings on your website and display them in search results. It will increase the attractiveness of your website snippet and, consequently, it will lead to a higher number of redirects from search engines.', 'testimonial-free' ) . '</div>',
								'subtitle'   => __( 'Enable/Disable schema.org markup.', 'testimonial-free' ),
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'default'    => false,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'preloader',
								'type'       => 'switcher',
								'title'      => __( 'Preloader', 'testimonial-free' ),
								'subtitle'   => __( 'Enable/Disable preloader.', 'testimonial-free' ),
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'default'    => false,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'type'    => 'notice',
								'class'   => 'ajax-notice',
								'content' => sprintf(
									/* translators: 1: start link tag, 2: close tag. */
									__( 'Want to display the Average Rating, Ajax Testimonial Search, and more? %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
									'</b></a>',
								),
							),
						),
					),
					array(
						'title'  => __( 'Testimonial Content', 'testimonial-free' ),
						'icon'   => '<i class="testimonial--icon sptfree-icon-testimonial-content"></i>',
						'fields' => array(
							array(
								'type'    => 'notice',
								'class'   => 'ajax-notice',

								'content' => sprintf(
									/* translators: %1$s: anchor tag starting, %2$s: anchor tag ending. */
									__( 'Looking to make your customer Testimonial Content more captivating with advanced customization options? %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
									'</b></a>'
								),
							),
							array(
								'id'         => 'testimonial_title',
								'type'       => 'switcher',
								'title'      => __( 'Testimonial Title', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide testimonial tagline or title.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'testimonial_title_length',
								'type'       => 'fieldset',
								'title'      => 'Length',
								'only_pro'   => true,
								'class'      => 'testimonial_text_limit',
								'subtitle'   => __( 'Leave it empty to show full title.', 'testimonial-free' ),
								'fields'     => array(
									array(
										'id'    => 'testimonial_title_limit',
										'class' => 'testimonial_limit_input',
										'type'  => 'spinner',
									),
									array(
										'id'         => 'testimonial_title_word_limit',
										'type'       => 'spinner',
										'default'    => '6',
										'dependency' => array( 'testimonial_title_length_type', '==', 'words', true ),
									),
									array(
										'id'      => 'testimonial_title_length_type',
										'class'   => 'testimonial_length_type',
										'type'    => 'select',
										'options' => array(
											'characters' => __( 'Characters (Pro)', 'testimonial-free' ),
											'words'      => __( 'Words (Pro)', 'testimonial-free' ),
										),
										'default' => 'characters',
									),
								),
								'dependency' => array( 'testimonial_title', '==', 'true', true ),
							),
							array(
								'id'         => 'testimonial_title_tag',
								'type'       => 'select',
								'title'      => __( 'HTML Tag', 'testimonial-free' ),
								'subtitle'   => __( 'Select testimonial title HTML tag.', 'testimonial-free' ),
								'sanitize'   => 'sanitize_text_field',
								'options'    => array(
									'h1'   => 'h1',
									'h2'   => 'h2',
									'h3'   => 'h3',
									'h4'   => 'h4',
									'h5'   => 'h5',
									'h6'   => 'h6',
									'p'    => 'p',
									'span' => 'span',
									'div'  => 'div',
								),
								'default'    => 'h3',
								'dependency' => array(
									'testimonial_title',
									'==',
									'true',
								),
							),
							array(
								'id'         => 'testimonial_title_quote_symbol',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'pro_switcher',
								'title'      => __( 'Add a Quote Symbol', 'testimonial-free' ),
								'subtitle'   => __( 'Add a quote symbol before testimonial title.', 'testimonial-free' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
							),
							array(
								'id'         => 'testimonial_text',
								'type'       => 'switcher',
								'title'      => __( 'Testimonial Content', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide testimonial content.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'testimonial_content_type',
								'type'       => 'button_set',
								'title'      => __( 'Content Display Type', 'testimonial-free' ),
								'subtitle'   => __( 'Choose content display type.', 'testimonial-free' ),
								'options'    => array(
									'full_content'       => __( 'Full', 'testimonial-free' ),
									'content_with_limit' => array(
										'option_name' => __( 'Limit', 'testimonial-free' ),
										'pro_only'    => true,
									),
								),
								'default'    => 'full_content',
								'sanitize'   => 'sanitize_text_field',
								'dependency' => array(
									'testimonial_text',
									'==',
									'true',
								),
							),
							array(
								'id'         => 'testimonial_content_length',
								'type'       => 'fieldset',
								'only_pro'   => true,
								'class'      => 'testimonial_text_limit',
								'title'      => 'Length',
								'subtitle'   => __( 'Set testimonial content length.', 'testimonial-free' ),
								'fields'     => array(
									array(
										'id'    => 'testimonial_characters_limit',
										'type'  => 'spinner',
										'class' => 'testimonial_limit_input',
									),
									array(
										'id'         => 'testimonial_word_limit',
										'type'       => 'spinner',
										'unit'       => __( 'word', 'testimonial-free' ),
										'default'    => '300',
										'dependency' => array( 'testimonial_content_length_type', '==', 'words', true ),
									),
									array(
										'id'      => 'testimonial_content_length_type',
										'type'    => 'select',
										'class'   => 'testimonial_length_type',
										'options' => array(
											'characters' => __( 'Characters (Pro)', 'testimonial-free' ),
											'words'      => __( 'Words (Pro)', 'testimonial-free' ),
										),
										'default' => 'characters',
									),
								),
								'dependency' => array( 'testimonial_text', '==', 'true', true ),
							),
							array(
								'id'         => 'testimonial_read_more',
								'type'       => 'switcher',
								'class'      => 'pro_switcher',
								'attributes' => array( 'disabled' => 'disabled' ),
								'title'      => __( 'Read More', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide testimonial read more button.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
								'sanitize'   => 'sanitize_text_field',
							),
							array(
								'id'       => 'testimonial_read_more_link_action',
								'class'    => 'pro_only_field',
								'type'     => 'button_set',
								'pro_only' => true,
								'title'    => __( 'Read More Action Type', 'testimonial-free' ),
								'subtitle' => __( 'Select read more link action type.', 'testimonial-free' ),
								'options'  => array(
									'expand' => __( 'Expand', 'testimonial-free' ),
									'popup'  => __( 'Popup', 'testimonial-free' ),
								),
								'default'  => 'expand',
							),
						),
					),
					array(
						'title'  => __( 'Reviewer Information', 'testimonial-free' ),
						'icon'   => '<i class="testimonial--icon sptfree-icon-reviewer-info"></i>',
						'fields' => array(
							array(
								'type'    => 'notice',
								'class'   => 'ajax-notice',
								'content' => sprintf(
									/* translators: 1: start link tag, 2: close tag. */
									__( 'Want to display more reviewer information and build trust & credibility? %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
									'</b></a>',
								),
							),
							array(
								'id'         => 'testimonial_client_name',
								'type'       => 'switcher',
								'title'      => __( 'Full Name', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide reviewer full name.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
								'sanitize'   => 'sanitize_text_field',
							),
							array(
								'id'         => 'testimonial_name_tag',
								'type'       => 'select',
								'title'      => __( 'HTML Tag', 'testimonial-free' ),
								'subtitle'   => __( 'Select reviewer name HTML tag.', 'testimonial-free' ),
								'sanitize'   => 'sanitize_text_field',
								'options'    => array(
									'h1'   => 'h1',
									'h2'   => 'h2',
									'h3'   => 'h3',
									'h4'   => 'h4',
									'h5'   => 'h5',
									'h6'   => 'h6',
									'p'    => 'p',
									'span' => 'span',
									'div'  => 'div',
								),
								'default'    => 'h4',
								'dependency' => array(
									'testimonial_client_name',
									'==',
									'true',
								),
							),
							array(
								'id'         => 'client_designation',
								'type'       => 'switcher',
								'title'      => __( 'Designation', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide identity or position.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
								'sanitize'   => 'sanitize_text_field',
							),
							array(
								'id'         => 'client_company_name',
								'type'       => 'switcher',
								'class'      => 'pro_switcher',
								'only_pro'   => true,
								'title'      => __( 'Company Name', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide company name.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
							),
							array(
								'id'         => 'client_company_logo',
								'type'       => 'switcher',
								'class'      => 'pro_switcher',
								'only_pro'   => true,
								'title'      => __( 'Company Logo', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide company Logo.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => false,
							),
							array(
								'id'         => 'testimonial_client_location',
								'type'       => 'switcher',
								'title'      => __( 'Location', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide Reviewer location.', 'testimonial-free' ),
								'class'      => 'pro_switcher',
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
								'only_pro'   => true,
							),
							array(
								'id'       => 'testimonial_client_location_country',
								'type'     => 'select_f',
								'title'    => __( 'Country', 'testimonial-free' ),
								'subtitle' => __( 'Choose a country display type.', 'testimonial-free' ),
								'sanitize' => 'sanitize_text_field',
								'only_pro' => true,
								'options'  => array(
									'name'              => array(
										'name'     => __( 'Country Name (Pro)', 'testimonial-free' ),
										'pro_only' => false,
									),
									'country_with_flag' => array(
										'name'     => __( 'Country Name with Flag (Pro)', 'testimonial-free' ),
										'pro_only' => true,
									),
									'flag'              => array(
										'name'     => __( 'Only Flag ', 'testimonial-free' ),
										'pro_only' => true,
									),
									'none'              => array(
										'name'     => __( 'None ', 'testimonial-free' ),
										'pro_only' => true,
									),
								),
								'default'  => 'name',
							),
							array(
								'id'         => 'testimonial_client_date',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'pro_switcher',
								'title'      => __( 'Date', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide testimonial date.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
							),
							array(
								'id'         => 'testimonial_date_format_type',
								'type'       => 'select',
								'only_pro'   => true,
								'title'      => __( 'Date Format', 'testimonial-free' ),
								'subtitle'   => __( 'Set date format.', 'testimonial-free' ),
								'class'      => 'post_meta_date_format',
								'options'    => array(
									'time_ago' => __( 'Time ago (human time)', 'testimonial-free' ),
									'default'  => __( 'Default', 'testimonial-free' ),
									'custom'   => __( 'Custom', 'testimonial-free' ),
								),
								'default'    => 'time_ago',
								'dependency' => array( 'testimonial_client_date', '==', 'true', true ),
							),
							array(
								'id'         => 'testimonial_date_format',
								'class'      => 'pro_only_field',
								'type'       => 'select',
								'only_pro'   => true,
								'title'      => ' ',
								'options'    => array(
									'M j, Y' => date_i18n( 'M j, Y' ) . ' (M j, Y)',
									'F j, Y' => date_i18n( 'F j, Y' ) . ' (F j, Y)',
									'Y-m-d'  => date_i18n( 'Y-m-d' ) . ' (Y-m-d)',
									'm/d/Y'  => date_i18n( 'm/d/Y' ) . ' (m/d/Y)',
									'd/m/Y'  => date_i18n( 'd/m/Y' ) . ' (d/m/Y)',
								),
								'default'    => 'M j, Y',
								'dependency' => array(
									'testimonial_client_date|testimonial_date_format_type',
									'==|==',
									'true|default',
									true,
								),
							),
							array(
								'id'         => 'testimonial_client_date_format',
								'type'       => 'text',
								'only_pro'   => true,
								'class'      => 'pro_only_field',
								'title'      => ' ',
								'default'    => 'M j, Y',
								'after'      => '<br><a target="_blank" href="https://wordpress.org/support/article/formatting-date-and-time/">Documentation on date formatting.</a>',
								'dependency' => array(
									'testimonial_client_date|testimonial_date_format_type',
									'==|==',
									'true|custom',
									true,
								),
							),
							array(
								'id'         => 'identity_linking_website',
								'type'       => 'checkbox',
								'class'      => 'pro_only_field',
								'title'      => __( 'Designation & Company Linking via Website URL', 'testimonial-free' ),
								'title_help' => __( 'Check to link designation & company name via website URL.', 'testimonial-free' ),
								'default'    => false,
								'only_pro'   => true,
							),
						),
					),
					array(
						'title'  => __( 'Star Rating', 'testimonial-free' ),
						'icon'   => '<i class="testimonial--icon fa fa-star-o"></i>',
						'fields' => array(
							array(
								'id'         => 'testimonial_client_rating',
								'type'       => 'switcher',
								'title'      => __( 'Star Rating', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide rating.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
								'sanitize'   => 'sanitize_text_field',
							),
							array(
								'id'         => 'tpro_star_icon',
								'class'      => 'tpro_star_icon',
								'type'       => 'image_select',
								'title'      => __( 'Rating Icon Style', 'testimonial-free' ),
								'subtitle'   => __( 'Choose a star rating icon style.', 'testimonial-free' ),
								'options'    => array(
									'rating-star-1'  => array(
										'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-1.svg',
									),
									'rating-star-2'  => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-2.svg',
										'pro_only' => true,
									),
									'rating-star-3'  => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-3.svg',
										'pro_only' => true,
									),
									'rating-star-4'  => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-4.svg',
										'pro_only' => true,
									),
									'rating-star-5'  => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-5.svg',
										'pro_only' => true,
									),
									'rating-star-6'  => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-6.svg',
										'pro_only' => true,
									),
									'rating-star-6b' => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-6b.svg',
										'pro_only' => true,
									),
									'rating-star-7'  => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-7.svg',
										'pro_only' => true,
									),
									'rating-star-7b' => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-7b.svg',
										'pro_only' => true,
									),
									'rating-star-8'  => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-8.svg',
										'pro_only' => true,
									),
									'rating-star-9'  => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-9.svg',
										'pro_only' => true,
									),
									'rating-star-10' => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-10.svg',
										'pro_only' => true,
									),
									'rating-star-11' => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-11.svg',
										'pro_only' => true,
									),
									'rating-star-12' => array(
										'image'    => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-12.svg',
										'pro_only' => true,
									),
									'rating-star-13' => array(
										'image' => SP_TFREE_URL . '/Admin/Views/Framework/assets/images/rating-icon/rating-star-13.svg',
										'class' => 'pro-feature',
									),
								),
								'default'    => 'rating-star-1',
								'dependency' => array( 'testimonial_client_rating', '==', 'true', true ),
							),
							array(
								'id'         => 'testimonial_client_rating_color',
								'type'       => 'color_group',
								'title'      => __( 'Rating Color', 'testimonial-free' ),
								'subtitle'   => __( 'Set color for the rating.', 'testimonial-free' ),
								'options'    => array(
									'color'       => __( 'Default', 'testimonial-free' ),
									'hover-color' => __( ' Rating', 'testimonial-free' ),
								),
								'default'    => array(
									'color'       => '#bbc2c7',
									'hover-color' => '#ffb900',
								),
								'dependency' => array( 'testimonial_client_rating', '==', 'true', true ),
							),
							array(
								'id'         => 'rating_icon_size',
								'type'       => 'spacing',
								'class'      => 'border_radius_by_spacing',
								'title'      => __( 'Rating Icon Size', 'testimonial-free' ),
								'subtitle'   => __( 'Set a size for the rating icon.', 'testimonial-free' ),
								'all_text'   => '',
								'all'        => true,
								'units'      => array( 'px' ),
								'default'    => array(
									'all'  => '19',
									'unit' => 'px',
								),
								'dependency' => array(
									'client_image|testimonial_client_rating',
									'==|==',
									'true|true',
									true,
								),
							),
							array(
								'id'         => 'rating_icon_gap',
								'type'       => 'spacing',
								'class'      => 'border_radius_by_spacing',
								'title'      => __( 'Gap', 'testimonial-free' ),
								'subtitle'   => __( 'Set a gap between the rating icons.', 'testimonial-free' ),
								'all_text'   => '',
								'all_icon'   => '<i class="fa fa-arrows-h"></i>',
								'all'        => true,
								'units'      => array( 'px' ),
								'default'    => array(
									'all'  => '2',
									'unit' => 'px',
								),
								'dependency' => array(
									'client_image|testimonial_client_rating',
									'==|==',
									'true|true',
									true,
								),
							),
							array(
								'id'         => 'rating_star_position',
								'type'       => 'select',
								'only_pro'   => true,
								'title'      => __( 'Rating Position', 'testimonial-free' ),
								'subtitle'   => __( 'Select a position for the star rating.', 'testimonial-free' ),
								'options'    => array(
									'below_name'    => __( 'Below Reviewer Name', 'testimonial-free' ),
									'below_reviewer_designation' => __( 'Below Reviewer Designation (Pro)', 'testimonial-free' ),
									'above_title'   => __( 'Above Testimonial Title (Pro)', 'testimonial-free' ),
									'below_title'   => __( 'Below Testimonial Title (Pro)', 'testimonial-free' ),
									'below_content' => __( 'Below Testimonial Content (Pro)', 'testimonial-free' ),
								),
								'default'    => 'below_name',
								'dependency' => array( 'testimonial_client_rating', '==', 'true', true ),
							),
						),
					),

					array(
						'title'  => __( 'Reviewer Image', 'testimonial-free' ),
						'icon'   => '<i class="testimonial--icon sptfree-icon-reviewer-image"></i>',
						'fields' => array(
							array(
								'type'    => 'notice',
								'class'   => 'ajax-notice',

								'content' => sprintf(
									/* translators: 1: start link tag, 2: close tag. */
									__( 'Want to enhance the Reviewer\'s Image using advanced customizations? %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
									'</b></a>',
								),
							),
							array(
								'id'         => 'client_image',
								'type'       => 'switcher',
								'title'      => __( 'Reviewer Image', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide reviewer image.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => true,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'image_sizes',
								'type'       => 'image_sizes',
								'title'      => __( 'Dimensions', 'testimonial-free' ),
								'subtitle'   => __( 'Select dimension for reviewer image.', 'testimonial-free' ),
								'default'    => 'tf-client-image-size',
								'sanitize'   => 'sanitize_text_field',
								'dependency' => array(
									'client_image',
									'==',
									'true',
								),
							),
							array(
								'id'         => 'image_custom_size',
								'type'       => 'custom_size',
								'class'      => 'disabled',
								'title'      => __( 'Custom Dimensions', 'testimonial-free' ),
								'subtitle'   => __( 'Set a custom width and height for the reviewer image.', 'testimonial-free' ),
								'default'    => array(
									'width'  => '120',
									'height' => '120',
									'crop'   => 'hard-crop',
									'unit'   => 'px',
								),
								'attributes' => array(
									'min' => 0,
								),
								'dependency' => array(
									'client_image|image_sizes',
									'==|==',
									'true|custom',
								),
							),
							array(
								'id'         => 'load_2x_image',
								'type'       => 'switcher',
								'class'      => 'pro_switcher',
								'attributes' => array( 'disabled' => 'disabled' ),
								'title'      => __( 'Load 2x Resolution Image in Retina Display', 'testimonial-free' ),
								'subtitle'   => __( 'You should upload 2x sized images to show in retina display.', 'testimonial-free' ),
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'default'    => false,
								'sanitize'   => 'rest_sanitize_boolean',
								'dependency' => array(
									'client_image|image_sizes',
									'==|==',
									'true|custom',
								),
							),
							array(
								'id'         => 'client_image_style',
								'class'      => 'client_image_style',
								'type'       => 'image_select',
								'title'      => __( 'Image Shape', 'testimonial-free' ),
								'subtitle'   => __( 'Choose a image shape.', 'testimonial-free' ),
								'sanitize'   => 'sanitize_text_field',
								'options'    => array(
									'three' => array(
										'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/image-shape/circle.svg',
										'name'  => __( 'Circle', 'testimonial-free' ),
									),
									'two'   => array(
										'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/image-shape/rounded.svg',
										'name'  => __( 'Rounded', 'testimonial-free' ),
										'class' => 'pro-feature',
									),
									'one'   => array(
										'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/image-shape/square.svg',
										'name'  => __( 'Square', 'testimonial-free' ),
										'class' => 'pro-feature',
									),
								),
								'default'    => 'three',
								'dependency' => array(
									'client_image',
									'==',
									'true',
								),
							),
							array(
								'id'         => 'reviewer_fallback_image',
								'type'       => 'radio',
								'class'      => 'pro_only_field',
								'title'      => __( 'Reviewer Fallback Images', 'testimonial-free' ),
								'subtitle'   => __( 'If no Featured Image is set, a reviewer fallback image can be used.', 'testimonial-free' ),
								'options'    => array(
									'no_fallback_img' => __( 'No Fallback Image', 'testimonial-free' ),
									'mystery_person'  => __( 'Mystery Person', 'testimonial-free' ),
									'text_avatar'     => __( 'Smart Text Avatars', 'testimonial-free' ),
								),
								'default'    => 'no_fallback_img',
								'dependency' => array(
									'client_image',
									'==',
									'true',
								),
							),
							array(
								'id'         => 'client_image_bg',
								'type'       => 'color',
								'title'      => __( 'Image Background', 'testimonial-free' ),
								'subtitle'   => __( 'Set reviewer image background color.', 'testimonial-free' ),
								'default'    => '#ffffff',
								'dependency' => array( 'client_image', '==', 'true', true ),
							),
							array(
								'id'         => 'image_padding',
								'type'       => 'spacing',
								'class'      => 'border_radius_by_spacing',
								'title'      => __( 'Padding', 'testimonial-free' ),
								'subtitle'   => __( 'Set padding for reviewer image.', 'testimonial-free' ),
								'title_help' => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/image_padding.svg" alt="' . __( 'Padding', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Padding', 'testimonial-free' ) . '</div>',
								'all_text'   => '',
								'all'        => true,
								'units'      => array( 'px' ),
								'default'    => array(
									'all'  => '0',
									'unit' => 'px',
								),
								'dependency' => array(
									'client_image',
									'==',
									'true',
									true,
								),
							),
							array(
								'id'         => 'image_border',
								'type'       => 'border',
								'title'      => __( 'Border', 'testimonial-free' ),
								'subtitle'   => __( 'Set reviewer image border.', 'testimonial-free' ),
								'all'        => true,
								'default'    => array(
									'all'   => '0',
									'style' => 'solid',
									'color' => '#dddddd',
									'unit'  => 'px',
								),
								'dependency' => array( 'client_image', '==', 'true', true ),
							),

							array(
								'id'         => 'client_image_border_shadow',
								'type'       => 'button_set',
								'title'      => __( 'BoxShadow', 'testimonial-free' ),
								'subtitle'   => __( 'Set boxshadow for the reviewer image.', 'testimonial-free' ),
								'options'    => array(
									'shadow_inset'  => __( 'Inset', 'testimonial-free' ),
									'shadow_outset' => __( 'Outset', 'testimonial-free' ),
									'none'          => __( 'None', 'testimonial-free' ),
								),
								'default'    => 'none',
								'dependency' => array(
									'client_image',
									'==',
									'true',
								),
							),
							array(
								'id'         => 'client_image_box_shadow_property',
								'type'       => 'box_shadow',
								'title'      => __( 'Box-Shadow Values', 'testimonial-free' ),
								'subtitle'   => __( 'Set reviewer image box-shadow property values.', 'testimonial-free' ),
								'default'    => array(
									'horizontal' => '0',
									'vertical'   => '0',
									'blur'       => '7',
									'spread'     => '0',
									'color'      => '#888888',
								),
								'dependency' => array(
									'client_image|client_image_border_shadow',
									'==|!=',
									'true|none',
									true,
								),
							),
							array(
								'id'         => 'img_lightbox',
								'type'       => 'switcher',
								'class'      => 'pro_switcher',
								'title'      => __( 'Lightbox ', 'testimonial-free' ),
								'subtitle'   => __( 'Enable/Disable reviewer image lightbox.', 'testimonial-free' ),
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'default'    => false,
							),
							array(
								'id'         => 'image_zoom_effect',
								'type'       => 'select',
								'class'      => 'chosen',
								'only_pro'   => true,
								'title'      => __( 'Zoom Effect', 'testimonial-free' ),
								'subtitle'   => __( 'Set a zoom effect on hover for the reviewer image.', 'testimonial-free' ),
								'options'    => array(
									''         => __( 'Normal', 'testimonial-free' ),
									'zoom_in'  => __( 'Zoom In (Pro)', 'testimonial-free' ),
									'zoom_out' => __( 'Zoom Out (Pro)', 'testimonial-free' ),
								),
								'default'    => '',
								'dependency' => array(
									'client_image|layout',
									'==|!=',
									'true|thumbnail_slider',
									true,
								),
							),
							array(
								'id'         => 'image_grayscale',
								'type'       => 'select',
								'title'      => __( 'Image Mode', 'testimonial-free' ),
								'subtitle'   => __( 'Select a image mode.', 'testimonial-free' ),
								'sanitize'   => 'sanitize_text_field',
								'options'    => array(
									'none'            => __( 'Normal', 'testimonial-free' ),
									'normal_on_hover' => __( 'Grayscale and normal on hover (Pro)', 'testimonial-free' ),
									'on_hover'        => __( 'Grayscale on hover (Pro)', 'testimonial-free' ),
									'always'          => __( 'Always grayscale (Pro)', 'testimonial-free' ),
								),
								'default'    => 'none',
								'dependency' => array(
									'client_image',
									'==',
									'true',
								),
							),
							array(
								'id'          => 'client_image_margin_tow',
								'type'        => 'spacing',
								'class'       => 'pro_only_field',
								'only_pro'    => true,
								'title'       => __( 'Margin', 'testimonial-free' ),
								'subtitle'    => __( 'Set margin for the reviewer image.', 'testimonial-free' ),
								'default'     => array(
									'top'    => '0',
									'right'  => '22',
									'bottom' => '0',
									'left'   => '0',
									'unit'   => 'px',
								),
								'top_text'    => __( 'Top', 'testimonial-free' ),
								'right_text'  => __( 'Right', 'testimonial-free' ),
								'bottom_text' => __( 'Bottom', 'testimonial-free' ),
								'left_text'   => __( 'Left', 'testimonial-free' ),
								'dependency'  => array(
									'client_image|theme_style',
									'==|==',
									'true|theme-nine',
									true,
								),
							),
						),
					),
					array(
						'title'  => __( 'Video Testimonial', 'testimonial-free' ),
						'icon'   => '<i class="testimonial--icon sptfree-icon-video-testimonial"></i>',
						'fields' => array(
							array(
								'type'    => 'notice',
								'class'   => 'ajax-notice',

								'content' => sprintf(
									/* translators: 1: start link tag, 2: close tag. */
									__( 'To allow customers to %4$sRecord Videos%2$s or Collect them manually to easily display %3$sVideo Testimonials%2$s and boost sales, %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
									'</b></a>',
									'<a target="_blank" href="https://realtestimonials.io/demos/video-testimonials/"><b>',
									'<a target="_blank" href="https://realtestimonials.io/demos/testimonial-forms/#video-record-form"><b>'
								),
							),
							array(
								'id'         => 'video_icon',
								'type'       => 'switcher',
								'class'      => 'pro_switcher',
								'attributes' => array( 'disabled' => 'disabled' ),
								'title'      => __( 'Video Testimonial', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide video testimonial.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => false,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'       => 'video_play_place',
								'type'     => 'button_set',
								'class'    => 'pro_only_field',
								'title'    => __( 'Video Play Mode', 'testimonial-free' ),
								'subtitle' => __( 'Select a mode video play.', 'testimonial-free' ),
								'options'  => array(
									'default' => __( 'Inline', 'testimonial-free' ),
									'popup'   => __( 'Popup', 'testimonial-free' ),
								),
								'default'  => 'popup',
							),
							array(
								'id'       => 'video_icon_size',
								'type'     => 'spinner',
								'class'    => 'pro_only_field',
								'title'    => __( 'Icon Size', 'testimonial-free' ),
								'subtitle' => __( 'Set testimonial icon size for video and lightbox.', 'testimonial-free' ),
								'default'  => '32',
							),
							array(
								'id'       => 'video_icon_color',
								'type'     => 'color_group',
								'class'    => 'pro_only_field',
								'title'    => __( 'Icon Color', 'testimonial-free' ),
								'subtitle' => __( 'Set testimonial icon color for video and lightbox.', 'testimonial-free' ),
								'options'  => array(
									'color'       => __( 'Color', 'testimonial-free' ),
									'hover-color' => __( 'Hover Color', 'testimonial-free' ),
								),
								'default'  => array(
									'color'       => '#e2e2e2',
									'hover-color' => '#ffffff',
								),
							),
							array(
								'id'       => 'video_icon_overlay',
								'type'     => 'color',
								'class'    => 'pro_only_field',
								'title'    => __( 'Icon Overlay Color', 'testimonial-free' ),
								'subtitle' => __( 'Set testimonial icon overlay color for video and lightbox.', 'testimonial-free' ),
								'default'  => 'rgba(51, 51, 51, 0.4)',
							),
						),
					),
					array(
						'title'  => __( 'Social Media', 'testimonial-free' ),
						'icon'   => '<i class="testimonial--icon sptfree-icon-social"></i>',
						'fields' => array(
							array(
								'type'    => 'notice',
								'class'   => 'ajax-notice',

								'content' => sprintf(
									/* translators: 1: start link tag, 2: close tag. */
									__( 'Want to display Social Media Profiles with reviewer information? %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
									'</b></a>'
								),
							),
							array(
								'id'         => 'social_profile',
								'type'       => 'switcher',
								'class'      => 'pro_switcher',
								'attributes' => array( 'disabled' => 'disabled' ),
								'title'      => __( 'Social Profiles', 'testimonial-free' ),
								'subtitle'   => __( 'Show/Hide social profiles.', 'testimonial-free' ),
								'text_on'    => __( 'Show', 'testimonial-free' ),
								'text_off'   => __( 'Hide', 'testimonial-free' ),
								'text_width' => 80,
								'default'    => false,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'social_profile_position',
								'type'       => 'button_set',
								'class'      => 'pro_only_field',
								'title'      => __( 'Alignment', 'testimonial-free' ),
								'subtitle'   => __( 'Social profiles alignment.', 'testimonial-free' ),
								'options'    => array(
									'left'   => '<i class="fa fa-align-left" title="left"></i>',
									'center' => '<i class="fa fa-align-center" title="center"></i>',
									'right'  => '<i class="fa fa-align-right" title="right"></i>',
								),
								'default'    => 'center',
								'dependency' => array(
									'social_profile',
									'==',
									'true',
									true,
								),
							),
							array(
								'id'         => 'social_icon_border_radius',
								'type'       => 'spacing',
								'class'      => 'pro_only_field',
								'title'      => __( 'Icon Border Radius', 'testimonial-free' ),
								'subtitle'   => __( 'Set social icon border radius.', 'testimonial-free' ),
								'all'        => true,
								'all_text'   => 'Width',
								'units'      => array(
									'px',
									'%',
								),
								'default'    => array(
									'all'  => '50',
									'unit' => '%',
								),
								'dependency' => array(
									'social_profile',
									'==',
									'true',
									true,
								),
							),
							array(
								'id'       => 'social_icon_color_type',
								'type'     => 'button_set',
								'class'    => 'pro_only_field',
								'title'    => __( 'Icon Color Type', 'testimonial-free' ),
								'subtitle' => __( 'Choose icon color type.', 'testimonial-free' ),
								'options'  => array(
									'original' => 'Original',
									'custom'   => 'Custom',
								),
								'default'  => 'original',
							),
							array(
								'id'       => 'social_icon_color',
								'type'     => 'color_group',
								'class'    => 'pro_only_field',
								'title'    => __( 'Icon Color', 'testimonial-free' ),
								'subtitle' => __( 'Set social icon color.', 'testimonial-free' ),
								'options'  => array(
									'color'            => __( 'Color', 'testimonial-free' ),
									'hover-color'      => __( 'Hover Color', 'testimonial-free' ),
									'background'       => __( 'Background', 'testimonial-free' ),
									'hover-background' => __( 'Hover Background', 'testimonial-free' ),
								),
								'default'  => array(
									'color'            => '#aaaaaa',
									'hover-color'      => '#ffffff',
									'background'       => 'transparent',
									'hover-background' => '#1595CE',
								),
							),
							array(
								'id'          => 'social_icon_border',
								'type'        => 'border',
								'class'       => 'pro_only_field',
								'title'       => __( 'Icon Border', 'testimonial-free' ),
								'subtitle'    => __( 'Set social icon border.', 'testimonial-free' ),
								'all'         => true,
								'hover_color' => true,
								'default'     => array(
									'all'         => '1',
									'style'       => 'solid',
									'color'       => '#dddddd',
									'hover-color' => '#1595CE',
								),
							),
							array(
								'id'          => 'social_profile_margin',
								'type'        => 'spacing',
								'class'       => 'pro_only_field',
								'title'       => __( 'Margin', 'testimonial-free' ),
								'subtitle'    => __( 'Set margin for social profiles.', 'testimonial-free' ),
								'title_help'  => '<div class="spftestimonial-img-tag"><img src="' . SP_TFREE_URL . 'Admin/Views/Framework/assets/images/help-visuals/social_media_margin.svg" alt="' . __( 'Margin', 'testimonial-free' ) . '"></div><div class="spftestimonial-info-label">' . __( 'Margin', 'testimonial-free' ) . '</div>',
								'default'     => array(
									'top'    => '15',
									'right'  => '0',
									'bottom' => '6',
									'left'   => '0',
									'unit'   => 'px',
								),
								'top_text'    => __( 'Top', 'testimonial-free' ),
								'right_text'  => __( 'Right', 'testimonial-free' ),
								'bottom_text' => __( 'Bottom', 'testimonial-free' ),
								'left_text'   => __( 'Left', 'testimonial-free' ),
								'units'       => array( 'px' ),
							),
						),
					),
				),
			),
		),
	)
);

//
// Slider Settings section.
//
SPFTESTIMONIAL::createSection(
	$prefix_shortcode_opts,
	array(
		'title'  => __( 'Slider Settings', 'testimonial-free' ),
		'icon'   => 'fa fa-sliders',
		'fields' => array(
			array(
				'type'  => 'tabbed',
				'class' => 'tabbed-inside-display-settings',
				'tabs'  => array(
					array(
						'title'  => __( 'Slider Basics', 'testimonial-free' ),
						'icon'   => '<span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none"><g clip-path="url(#A)"><path fill-rule="evenodd" d="M1.224 1.224c-.009.009-.024.03-.024.076v13.4c0 .046.015.067.024.076s.03.024.076.024h13.4c.02-.017.019-.043.012-.082l-.012-.058V14.6 1.3c0-.046-.015-.067-.024-.076s-.03-.024-.076-.024H1.3c-.046 0-.067.015-.076.024zM0 1.3A1.28 1.28 0 0 1 1.3 0h13.3a1.28 1.28 0 0 1 1.3 1.3v13.247c.058.368-.014.734-.248 1.02-.244.299-.602.433-.952.433H1.3A1.28 1.28 0 0 1 0 14.7V1.3zm12.4 3h-.9c-.3-.7-1.1-1.2-1.9-1.2-.9 0-1.6.5-1.9 1.2H3.6c-.5 0-.9.4-.9.9s.4.9.9.9h4.1c.3.8 1 1.3 1.9 1.3s1.6-.5 1.9-1.2h.9c.5 0 .9-.4.9-.9s-.4-1-.9-1zm-7.9 7.4h-.9c-.5 0-.9-.4-.9-.9s.4-.9.9-.9h.9c.3-.8 1-1.3 1.9-1.3s1.6.5 1.9 1.3h4.1c.5 0 .9.4.9.9s-.4.9-.9.9H8.3c-.3.7-1 1.2-1.9 1.2-.8 0-1.6-.5-1.9-1.2z" fill="#000"/></g><defs><clipPath id="A"><path fill="#fff" d="M0 0h16v16H0z"/></clipPath></defs></svg></span>',
						'fields' => array(
							array(
								'id'     => 'carousel_autoplay',
								'class'  => 'sp_testimonial-navigation-and-pagination-style autoplay',
								'type'   => 'fieldset',
								'fields' => array(
									array(
										'id'         => 'slider_auto_play',
										'type'       => 'switcher',
										'title'      => __( 'AutoPlay', 'testimonial-free' ),
										'subtitle'   => __( 'Enable/Disable autoplay.', 'testimonial-free' ),
										'class'      => 'sp_testimonial_navigation',
										'text_on'    => __( 'Enabled', 'testimonial-free' ),
										'text_off'   => __( 'Disabled', 'testimonial-free' ),
										'text_width' => 100,
										'default'    => true,
									),
									array(
										'id'         => 'autoplay_disable_on_mobile',
										'type'       => 'checkbox',
										'class'      => 'spt_disable_on_mobile',
										'title'      => __( 'Disable on Mobile', 'testimonial-free' ),
										'default'    => false,
										'dependency' => array( 'carousel_mode|slider_auto_play', '!=|!=', 'ticker|false', true ),
									),
								),
							),
							array(
								'id'         => 'slider_auto_play_speed',
								'type'       => 'slider',
								'title'      => __( 'AutoPlay Delay', 'testimonial-free' ),
								'subtitle'   => __( 'Set auto play delay time in millisecond.', 'testimonial-free' ),
								'title_help' => '<div class="spftestimonial-info-label">' . __( 'AutoPlay Delay Time', 'testimonial-free' ) . '</div><div class="spftestimonial-short-content">' . __( 'Set autoplay delay or interval time. The amount of time to delay between automatically cycling a testimonial item. e.g. 1000 milliseconds(ms) = 1 second.', 'testimonial-free' ) . '</div>',
								'max'        => 30000,
								'min'        => 100,
								'default'    => 3000,
								'step'       => 100,
								'sanitize'   => 'spftestimonial_sanitize_number_field',
								'unit'       => __( 'ms', 'testimonial-free' ),
								'dependency' => array(
									'slider_auto_play',
									'!=',
									'false',
								),
							),
							array(
								'id'         => 'slider_scroll_speed',
								'type'       => 'slider',
								'title'      => __( 'Pagination Speed', 'testimonial-free' ),
								'subtitle'   => __( 'Set pagination speed in millisecond.', 'testimonial-free' ),
								'title_help' => '<div class="spftestimonial-info-label">' . __( 'Pagination Speed', 'testimonial-free' ) . '</div><div class="spftestimonial-short-content">' . __( 'Set carousel scrolling speed. e.g. 1000 milliseconds(ms) = 1 second.', 'testimonial-free' ) . '</div>',
								'unit'       => __( 'ms', 'testimonial-free' ),
								'sanitize'   => 'spftestimonial_sanitize_number_field',
								'max'        => 10000,
								'min'        => 10,
								'default'    => 600,
								'step'       => 10,
							),
							array(
								'id'         => 'slider_pause_on_hover',
								'type'       => 'switcher',
								'title'      => __( 'Pause on Hover', 'testimonial-free' ),
								'subtitle'   => __( 'Enable/Disable slider pause on hover.', 'testimonial-free' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'sanitize'   => 'rest_sanitize_boolean',
								'dependency' => array(
									'slider_auto_play',
									'!=',
									'false',
								),
							),
							array(
								'id'         => 'slider_infinite',
								'type'       => 'switcher',
								'title'      => __( 'Infinite Loop', 'testimonial-free' ),
								'subtitle'   => __( 'Enable/Disable infinite loop mode.', 'testimonial-free' ),
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'default'    => true,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'       => 'slider_animation',
								'type'     => 'select',
								'title'    => __( 'Transition Effect', 'testimonial-free' ),
								'subtitle' => __( 'Select a transition effect or animation.', 'testimonial-free' ),
								'sanitize' => 'sanitize_text_field',
								'options'  => array(
									'slide'            => __( 'Slide', 'testimonial-free' ),
									'fade'             => __( 'Fade (Pro)', 'testimonial-free' ),
									'flipHorizontally' => __( 'Flip Horizontally (Pro)', 'testimonial-free' ),
									'flipVertically'   => __( 'Flip Vertically (Pro)', 'testimonial-free' ),
								),
								'default'  => 'slide',
							),
							array(
								'id'       => 'slider_direction',
								'type'     => 'button_set',
								'sanitize' => 'sanitize_text_field',
								'title'    => __( 'Direction', 'testimonial-free' ),
								'subtitle' => __( 'Slider direction.', 'testimonial-free' ),
								'options'  => array(
									'ltr' => __( 'Right to Left', 'testimonial-free' ),
									'rtl' => __( 'Left to Right', 'testimonial-free' ),
								),
								'default'  => 'ltr',
							),
							array(
								'type'    => 'notice',
								'class'   => 'slider-basic-notice ajax-notice',
								'content' => sprintf(
									/* translators: 1: start link tag, 2: close tag. */
									__( 'Ready to fascinate your audience with beautiful transitions, such as Fade, Flip Horizontally and Vertically? %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
									'</b></a>',
								),
							),
						),
					),
					array(
						'title'  => __( 'Navigation', 'testimonial-free' ),
						'icon'   => '<span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#343434" ><path d="M2.2 8l4.1-4.1a.85.85 0 0 0 0-1.3c-.4-.3-1-.3-1.3.1L.3 7.4a.85.85 0 0 0 0 1.3L5 13.3c.3.3.9.3 1.2 0a.85.85 0 0 0 0-1.3l-4-4zM11 2.7l4.7 4.7c.4.3.4.9-.1 1.3l-4.7 4.7c-.4.4-1 .2-1.2 0a.85.85 0 0 1 0-1.3L13.8 8l-4-4.1c-.4-.3-.4-.9-.1-1.2a.85.85 0 0 1 1.3 0zM6.5 6a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h3a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1h-3z"/></svg></span>',
						'fields' => array(
							array(
								'type'    => 'notice',
								'class'   => 'ajax-notice',
								'content' => sprintf(
									/* translators: 1: start link tag, 2: close tag. */
									__( 'Want even more fine-tuned control over your Slider Navigation display? %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
									'</b></a>',
								),
							),
							array(
								'id'     => 'spt_carousel_navigation',
								'class'  => 'sp_testimonial-navigation-and-pagination-style',
								'type'   => 'fieldset',
								'fields' => array(
									array(
										'id'         => 'navigation',
										'type'       => 'switcher',
										'class'      => 'sp_testimonial_navigation',
										'title'      => __( 'Navigation', 'testimonial-free' ),
										'subtitle'   => __( 'Show/Hide the navigation.', 'testimonial-free' ),
										'default'    => true,
										'text_on'    => __( 'Show', 'testimonial-free' ),
										'text_off'   => __( 'Hide', 'testimonial-free' ),
										'text_width' => 80,
										'dependency' => array( 'carousel_mode', '!=', 'ticker', true ),
									),
									array(
										'id'         => 'navigation_hide_on_mobile',
										'type'       => 'checkbox',
										'class'      => 'spt_hide_on_mobile',
										'title'      => __( 'Hide on Mobile', 'testimonial-free' ),
										'default'    => false,
										'dependency' => array( 'carousel_mode|navigation', '!=|==', 'ticker|true', true ),
									),
								),
							),
							array(
								'id'         => 'navigation_position',
								'type'       => 'select',
								'class'      => 'chosen spftestimonial-carousel-nav-position',
								'title'      => __( 'Select Position', 'testimonial-free' ),
								'subtitle'   => __( 'Select a position for the navigation arrows.', 'testimonial-free' ),
								'desc'       => sprintf(
									/* translators: %1$s: Help text starting tag, %2$s: starting of anchor tag, %3$s: ending of anchor tag. */
									__( '%1$sThis is a %2$sPro Feature!%3$s', 'testimonial-free' ),
									'<div class="sp_carousel-navigation-notice">',
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1">',
									'</a></div>'
								),
								'preview'    => true,
								'only_pro'   => true,
								'options'    => array(
									'vertical_outer'  => __( 'Vertical Outer', 'testimonial-free' ),
									'top_right'       => __( 'Top Right', 'testimonial-free' ),
									'top_center'      => __( 'Top Center', 'testimonial-free' ),
									'top_left'        => __( 'Top Left', 'testimonial-free' ),
									'bottom_left'     => __( 'Bottom Left', 'testimonial-free' ),
									'bottom_center'   => __( 'Bottom Center', 'testimonial-free' ),
									'bottom_right'    => __( 'Bottom Right', 'testimonial-free' ),
									'vertical_inner'  => __( 'Vertical Inner', 'testimonial-free' ),
									'vertical_center' => __( 'Vertical Center', 'testimonial-free' ),
								),
								'default'    => 'vertical_outer',
								'dependency' => array( 'navigation|carousel_mode', '!=|!=', 'false|ticker', true ),
							),
							array(
								'id'         => 'nav_visible_on_hover',
								'type'       => 'checkbox',
								'class'      => 'pro_only_field',
								'title'      => __( 'Show On Hover', 'testimonial-free' ),
								'subtitle'   => __( 'Check to show navigation on hover.', 'testimonial-free' ),
								'default'    => false,
								'dependency' => array(
									'navigation|carousel_mode|navigation_position',
									'!=|!=|any',
									'false|ticker|vertical_inner,vertical_center,vertical_outer',
									true,
								),
							),
							array(
								'id'         => 'navigation_icons',
								'type'       => 'button_set',
								'class'      => 'navigation_icons pro_only_field',
								'title'      => __( 'Navigation Arrow Style', 'testimonial-free' ),
								'subtitle'   => __( 'choose a navigation arrow icon style.', 'testimonial-free' ),
								'options'    => array(
									'angle'              => '<i class="sptfree-icon-angle-right"></i>',
									'chevron_open_big'   => '<i class="sptfree-icon-right-open-big"></i>',
									'right_open'         => '<i class="sptfree-icon-right-open"></i>',
									'chevron'            => '<i class="sptfree-icon-right-open-1"></i>',
									'right_open_3'       => '<i class="sptfree-icon-right-open-3"></i>',
									'right_open_outline' => '<i class="sptfree-icon-right-open-outline"></i>',
									'arrow'              => '<i class="sptfree-icon-right"></i>',
									'triangle'           => '<i class="sptfree-icon-arrow-triangle-right"></i>',
								),
								'default'    => 'angle',
								'dependency' => array(
									'navigation|carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
							array(
								'id'         => 'navigation_icon_size',
								'type'       => 'spinner',
								'class'      => 'pro_only_field',
								'title'      => __( 'Navigation Icon Size', 'testimonial-free' ),
								'subtitle'   => __( 'Change navigation icon size.', 'testimonial-free' ),
								'default'    => '20',
								'dependency' => array(
									'navigation|carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
							array(
								'id'         => 'navigation_color',
								'type'       => 'color_group',
								'title'      => __( 'Navigation Color', 'testimonial-free' ),
								'subtitle'   => __( 'Set the navigation color.', 'testimonial-free' ),
								'options'    => array(
									'color'            => __( 'Color', 'testimonial-free' ),
									'hover-color'      => __( 'Hover Color', 'testimonial-free' ),
									'background'       => __( 'Background', 'testimonial-free' ),
									'hover-background' => __( 'Hover Background', 'testimonial-free' ),
								),
								'default'    => array(
									'color'            => '#777777',
									'hover-color'      => '#ffffff',
									'background'       => 'transparent',
									'hover-background' => '#1595CE',
								),
								'dependency' => array(
									'navigation|carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
							array(
								'id'          => 'navigation_border',
								'type'        => 'border',
								'title'       => __( 'Navigation Border', 'testimonial-free' ),
								'subtitle'    => __( 'Set the navigation border.', 'testimonial-free' ),
								'all'         => true,
								'hover_color' => true,
								'default'     => array(
									'all'         => '1',
									'style'       => 'solid',
									'color'       => '#777777',
									'hover-color' => '#1595CE',
								),
								'dependency'  => array(
									'navigation|carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
							array(
								'id'         => 'navigation_border_radius',
								'type'       => 'spacing',
								'class'      => 'pro_only_field',
								'title'      => __( 'Border Radius', 'testimonial-free' ),
								'subtitle'   => __( 'Set the navigation border radius.', 'testimonial-free' ),
								'all'        => true,
								'units'      => array(
									'px',
									'%',
								),
								'default'    => array(
									'all'  => '50',
									'unit' => '%',
								),
								'dependency' => array(
									'navigation|carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
						),
					),
					array(
						'title'  => __( 'Pagination', 'testimonial-free' ),
						'icon'   => '<span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" ><g clip-path="url(#A)" fill="#343434"><path d="M5.2 10.2a2.2 2.2 0 1 0 0-4.4 2.2 2.2 0 1 0 0 4.4zm6.2-.5a1.7 1.7 0 0 0 0-3.4 1.7 1.7 0 0 0 0 3.4z"/><path fill-rule="evenodd" d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4zm2-.5h12a.5.5 0 0 1 .5.5v8a.5.5 0 0 1-.5.5H2a.5.5 0 0 1-.5-.5V4a.5.5 0 0 1 .5-.5z"/></g><defs><clipPath id="A"><path fill="#fff" d="M0 0h16v16H0z"/></clipPath></defs></svg></span>',
						'fields' => array(
							array(
								'type'    => 'notice',
								'class'   => 'ajax-notice',
								'content' => sprintf(
									/* translators: 1: start link tag, 2: close tag. */
									__( 'Want even more fine-tuned control over your Slider Pagination display? %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
									'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
									'</b></a>',
								),
							),
							array(
								'id'     => 'spt_carousel_pagination',
								'class'  => 'sp_testimonial-navigation-and-pagination-style',
								'type'   => 'fieldset',
								'fields' => array(
									array(
										'id'         => 'pagination',
										'type'       => 'switcher',
										'class'      => 'sp_testimonial_pagination',
										'title'      => __( 'Pagination', 'testimonial-free' ),
										'subtitle'   => __( 'Show/Hide the pagination.', 'testimonial-free' ),
										'default'    => true,
										'text_on'    => __( 'Show', 'testimonial-free' ),
										'text_off'   => __( 'Hide', 'testimonial-free' ),
										'text_width' => 80,
									),
									array(
										'id'         => 'pagination_hide_on_mobile',
										'type'       => 'checkbox',
										'class'      => 'spt_hide_on_mobile',
										'title'      => __( 'Hide on Mobile', 'testimonial-free' ),
										'default'    => false,
										'dependency' => array( 'pagination', '==', 'true', true ),
									),
								),
							),
							array(
								'id'         => 'carousel_pagination_type',
								'type'       => 'image_select',
								'class'      => 'carousel_pagination_style',
								'title'      => __( 'Pagination Style', 'testimonial-free' ),
								'subtitle'   => __( 'Select carousel pagination type.', 'testimonial-free' ),
								'options'    => array(
									'dots'      => array(
										'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/pagination/bullets.svg',
										'name'  => __( 'Bullets', 'testimonial-free' ),
									),
									'dynamic'   => array(
										'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/pagination/dynamic.svg',
										'name'  => __( 'Dynamic', 'testimonial-free' ),
										'class' => 'pro-feature',
									),
									'strokes'   => array(
										'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/pagination/strokes.svg',
										'name'  => __( 'Strokes', 'testimonial-free' ),
										'class' => 'pro-feature',
									),
									'scrollbar' => array(
										'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/pagination/scrollbar.svg',
										'name'  => __( 'Scrollbar', 'testimonial-free' ),
										'class' => 'pro-feature',
									),
									'fraction'  => array(
										'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/pagination/fraction.svg',
										'name'  => __( 'Fraction', 'testimonial-free' ),
										'class' => 'pro-feature',
									),
									'numbers'   => array(
										'image' => SP_TFREE_URL . 'Admin/Views/Framework/assets/images/pagination/custom-numbers.svg',
										'name'  => __( 'Numbers', 'testimonial-free' ),
										'class' => 'pro-feature',
									),
								),
								'radio'      => true,
								'default'    => 'dots',
								'dependency' => array( 'pagination', '!=', 'false', true ),
							),
							array(
								'id'         => 'pagination_colors',
								'type'       => 'color_group',
								'title'      => __( 'Color', 'testimonial-free' ),
								'subtitle'   => __( 'Set the pagination color.', 'testimonial-free' ),
								'sanitize'   => 'spftestimonial_sanitize_color_group_field',
								'options'    => array(
									'color'        => __( 'Color', 'testimonial-free' ),
									'active-color' => __( 'Active Color', 'testimonial-free' ),
								),
								'default'    => array(
									'color'        => '#cccccc',
									'active-color' => '#1595ce',
								),
								'dependency' => array(
									'pagination',
									'!=',
									'false',
								),
							),
							array(
								'id'          => 'pagination_margin',
								'type'        => 'spacing',
								'class'       => 'pro_only_field',
								'title'       => __( 'Margin', 'testimonial-free' ),
								'subtitle'    => __( 'Set pagination margin.', 'testimonial-free' ),
								'default'     => array(
									'top'    => '21',
									'right'  => '0',
									'bottom' => '8',
									'left'   => '0',
									'unit'   => 'px',
								),
								'top_text'    => __( 'Top', 'testimonial-free' ),
								'right_text'  => __( 'Right', 'testimonial-free' ),
								'bottom_text' => __( 'Bottom', 'testimonial-free' ),
								'left_text'   => __( 'Left', 'testimonial-free' ),
								'units'       => array( 'px' ),
								'dependency'  => array( 'pagination|carousel_mode', '!=|!=', 'false|ticker', true ),
							),
						),
					),
					array(
						'title'  => __( 'Miscellaneous', 'testimonial-free' ),
						'icon'   => '<span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none"><g clip-path="url(#A)" fill="#343434"><path d="M12.4 3.9h-6c-.4 0-.8.4-.8.8s.4.8.8.8h6c.4 0 .8-.3.8-.8 0-.4-.3-.8-.8-.8zm0 3.3h-6c-.4 0-.8.4-.8.8s.4.8.8.8h6c.4 0 .8-.3.8-.8 0-.4-.3-.8-.8-.8zm-6 3.2h6c.5 0 .8.4.8.8 0 .5-.4.8-.8.8h-6c-.4 0-.8-.4-.8-.8s.4-.8.8-.8zM4.9 4.8a.94.94 0 0 1-1 1c-.5 0-1-.4-1-1a.94.94 0 0 1 1-1 .94.94 0 0 1 1 1zM3.9 9a.94.94 0 0 0 1-1 .94.94 0 0 0-1-1 .94.94 0 0 0-1 1c0 .6.5 1 1 1zm1 2.2a.94.94 0 0 1-1 1c-.5 0-1-.4-1-1a.94.94 0 0 1 1-1 .94.94 0 0 1 1 1z"/><path fill-rule="evenodd" d="M13.2 0H2.9C1.3 0 0 1.3 0 2.9v10.2C0 14.7 1.3 16 2.9 16h10.2c1.6 0 2.9-1.3 2.9-2.8V2.9C16 1.3 14.7 0 13.2 0zm1.4 13.2c0 .8-.6 1.4-1.4 1.4H2.9c-.8 0-1.4-.6-1.4-1.4V2.9c0-.8.6-1.4 1.4-1.4h10.3c.8 0 1.4.6 1.4 1.4v10.3z"/></g><defs><clipPath id="A"><path fill="#fff" d="M0 0h16v16H0z"/></clipPath></defs></svg></span>',
						'fields' => array(
							array(
								'id'         => 'adaptive_height',
								'type'       => 'switcher',
								'title'      => __( 'Adaptive Slider Height', 'testimonial-free' ),
								'subtitle'   => __( 'Dynamically adjust slider height based on each slide\'s height.', 'testimonial-free' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'slider_swipe',
								'type'       => 'switcher',
								'title'      => __( 'Touch Swipe', 'testimonial-free' ),
								'subtitle'   => __( 'Enable/Disable swipe mode.', 'testimonial-free' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'slider_draggable',
								'type'       => 'switcher',
								'title'      => __( 'Mouse Draggable', 'testimonial-free' ),
								'subtitle'   => __( 'Enable/Disable mouse draggable mode.', 'testimonial-free' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'dependency' => array( 'slider_swipe', '==', 'true' ),
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'free_mode',
								'type'       => 'switcher',
								'title'      => __( 'Free Mode', 'testimonial-free' ),
								'subtitle'   => __( 'Enable/Disable free mode.', 'testimonial-free' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'sanitize'   => 'rest_sanitize_boolean',
							),
							array(
								'id'         => 'swipe_to_slide',
								'type'       => 'switcher',
								'title'      => __( 'Mouse Wheel', 'testimonial-free' ),
								'subtitle'   => __( 'Enable/Disable mouse wheel.', 'testimonial-free' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'testimonial-free' ),
								'text_off'   => __( 'Disabled', 'testimonial-free' ),
								'text_width' => 100,
								'sanitize'   => 'rest_sanitize_boolean',
							),
						),
					),
				),
			),
		),
	)
);

//
// Typography section.
//
SPFTESTIMONIAL::createSection(
	$prefix_shortcode_opts,
	array(
		'title'  => __( 'Typography', 'testimonial-free' ),
		'icon'   => 'fa fa-font',
		'fields' => array(
			array(
				'type'    => 'notice',
				'class'   => 'ajax-notice',
				'style'   => 'normal',
				'content' => sprintf(
					/* translators: 1: start link tag, 2: close tag. */
					__( 'Want to customize everything (Typography, Colors, Margin) easily? %1$sUpgrade to Pro!%2$s P.S. Note: The color fields work in the lite version.', 'testimonial-free' ),
					'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
					'</b></a>',
				),
			),
			array(
				'id'       => 'section_title_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Section Title Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the section title.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'section_title_typography',
				'type'          => 'typography',
				'title'         => __( 'Section Title Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set testimonial section title font properties.', 'testimonial-free' ),
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => '600',
					'type'           => 'google',
					'font-size'      => '22',
					'line-height'    => '22',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#444444',
					'margin-bottom'  => '23',
				),
				'margin_bottom' => true,
				'preview'       => true,
				'preview_text'  => 'What Our Customers Saying', // Replace preview text with any text you like.
			),
			array(
				'id'       => 'testimonial_title_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Testimonial Title Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the testimonial tagline or title.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'testimonial_title_typography',
				'type'          => 'typography',
				'title'         => __( 'Testimonial Title Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set testimonial tagline or title font properties.', 'testimonial-free' ),
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => '600',
					'type'           => 'google',
					'font-size'      => '20',
					'line-height'    => '30',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#333333',
					'margin-top'     => '0',
					'margin-right'   => '0',
					'margin-bottom'  => '18',
					'margin-left'    => '0',
				),
				'margin_top'    => true,
				'margin_right'  => true,
				'margin_bottom' => true,
				'margin_left'   => true,
				'preview'       => true,
				'preview_text'  => 'The Testimonial Title', // Replace preview text with any text you like.
			),
			array(
				'id'       => 'testimonial_text_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Testimonial Content Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the testimonial content.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'testimonial_text_typography',
				'type'          => 'typography',
				'title'         => __( 'Testimonial Content Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set testimonial content font properties.', 'testimonial-free' ),
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => 'normal',
					'type'           => 'google',
					'font-size'      => '16',
					'line-height'    => '26',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#333333',
					'margin-top'     => '0',
					'margin-right'   => '0',
					'margin-bottom'  => '20',
					'margin-left'    => '0',
				),
				'color'         => true,
				'preview'       => true,
				'margin_top'    => true,
				'margin_right'  => true,
				'margin_bottom' => true,
				'margin_left'   => true,
			),
			array(
				'id'       => 'client_name_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Name Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the name.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'client_name_typography',
				'type'          => 'typography',
				'title'         => __( 'Name Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set name font properties.', 'testimonial-free' ),
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => '700',
					'type'           => 'google',
					'font-size'      => '16',
					'line-height'    => '24',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#333333',
					'margin-top'     => '0',
					'margin-right'   => '0',
					'margin-bottom'  => '8',
					'margin-left'    => '0',
				),
				'color'         => true,
				'preview'       => true,
				'margin_top'    => true,
				'margin_right'  => true,
				'margin_bottom' => true,
				'margin_left'   => true,
				'preview_text'  => 'Jacob Firebird', // Replace preview text with any text you like.
			),
			array(
				'id'       => 'designation_company_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Designation & Company Name Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the Designation & company name.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'client_designation_company_typography',
				'type'          => 'typography',
				'title'         => __( 'Designation & Company Name Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set Designation & company name font properties.', 'testimonial-free' ),
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => 'normal',
					'type'           => 'google',
					'font-size'      => '16',
					'line-height'    => '24',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#444444',
					'margin-top'     => '0',
					'margin-right'   => '0',
					'margin-bottom'  => '8',
					'margin-left'    => '0',
				),
				'color'         => true,
				'preview'       => true,
				'margin_top'    => true,
				'margin_right'  => true,
				'margin_bottom' => true,
				'margin_left'   => true,
				'preview_text'  => 'CEO - Firebird Media Inc.', // Replace preview text with any text you like.
			),
			array(
				'id'       => 'location_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Location Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the location.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'client_location_typography',
				'type'          => 'typography',
				'title'         => __( 'Location Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set location font properties.', 'testimonial-free' ),
				'class'         => 'sp-testimonial-font-color',
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => 'normal',
					'type'           => 'google',
					'font-size'      => '15',
					'line-height'    => '20',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#444444',
					'margin-top'     => '0',
					'margin-right'   => '0',
					'margin-bottom'  => '5',
					'margin-left'    => '0',
				),
				'color'         => true,
				'preview'       => true,
				'margin_top'    => true,
				'margin_right'  => true,
				'margin_bottom' => true,
				'margin_left'   => true,
				'preview_text'  => 'Los Angeles', // Replace preview text with any text you like.
			),
			array(
				'id'       => 'phone_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Phone or Mobile Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the phone or mobile.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'client_phone_typography',
				'type'          => 'typography',
				'title'         => __( 'Phone or Mobile Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set phone or mobile font properties.', 'testimonial-free' ),
				'class'         => 'sp-testimonial-font-color',
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => 'normal',
					'type'           => 'google',
					'font-size'      => '15',
					'line-height'    => '20',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#444444',
					'margin-top'     => '0',
					'margin-right'   => '0',
					'margin-bottom'  => '3',
					'margin-left'    => '0',
				),
				'color'         => true,
				'preview'       => true,
				'margin_top'    => true,
				'margin_right'  => true,
				'margin_bottom' => true,
				'margin_left'   => true,
				'preview_text'  => '+1 234567890', // Replace preview text with any text you like.
			),
			array(
				'id'       => 'email_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Email Address Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the email address.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'client_email_typography',
				'type'          => 'typography',
				'title'         => __( 'Email Address Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set email address font properties.', 'testimonial-free' ),
				'class'         => 'sp-testimonial-font-color',
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => 'normal',
					'type'           => 'google',
					'font-size'      => '15',
					'line-height'    => '20',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#444444',
					'margin-top'     => '0',
					'margin-right'   => '0',
					'margin-bottom'  => '5',
					'margin-left'    => '0',
				),
				'color'         => true,
				'preview'       => true,
				'margin_top'    => true,
				'margin_right'  => true,
				'margin_bottom' => true,
				'margin_left'   => true,
				'preview_text'  => 'mail@yourwebsite.com', // Replace preview text with any text you like.
			),
			array(
				'id'       => 'date_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Date Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the date.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'testimonial_date_typography',
				'type'          => 'typography',
				'title'         => __( 'Date Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set date font properties.', 'testimonial-free' ),
				'class'         => 'sp-testimonial-font-color',
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => 'normal',
					'type'           => 'google',
					'font-size'      => '15',
					'line-height'    => '20',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#444444',
					'margin-top'     => '0',
					'margin-right'   => '0',
					'margin-bottom'  => '6',
					'margin-left'    => '0',
				),
				'color'         => true,
				'preview'       => true,
				'margin_top'    => true,
				'margin_right'  => true,
				'margin_bottom' => true,
				'margin_left'   => true,
				'preview_text'  => 'February 21, 2018', // Replace preview text with any text you like.
			),
			array(
				'id'       => 'website_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Website Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the website.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'            => 'client_website_typography',
				'type'          => 'typography',
				'title'         => __( 'Website Font', 'testimonial-free' ),
				'subtitle'      => __( 'Set website font properties.', 'testimonial-free' ),
				'class'         => 'sp-testimonial-font-color',
				'default'       => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => 'normal',
					'type'           => 'google',
					'font-size'      => '15',
					'line-height'    => '20',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
					'color'          => '#444444',
					'margin-top'     => '0',
					'margin-right'   => '0',
					'margin-bottom'  => '6',
					'margin-left'    => '0',
				),
				'color'         => true,
				'preview'       => true,
				'margin_top'    => true,
				'margin_right'  => true,
				'margin_bottom' => true,
				'margin_left'   => true,
				'preview_text'  => 'www.yourwebsite.com', // Replace preview text with any text you like.
			),
			array(
				'id'       => 'filter_font_load',
				'type'     => 'switcher',
				'title'    => __( 'Load Isotope Filter Button Font', 'testimonial-free' ),
				'subtitle' => __( 'On/Off google font for the isotope filter button.', 'testimonial-free' ),
				'class'    => 'sp-testimonial-font-load',
				'default'  => true,
				'sanitize' => 'rest_sanitize_boolean',
			),
			array(
				'id'           => 'filter_typography',
				'type'         => 'typography',
				'title'        => __( 'Isotope Filter Button Font', 'testimonial-free' ),
				'subtitle'     => __( 'Set isotope filter button font properties.', 'testimonial-free' ),
				'default'      => array(
					'font-family'    => 'Open Sans',
					'font-weight'    => 'normal',
					'type'           => 'google',
					'font-size'      => '15',
					'line-height'    => '20',
					'text-align'     => 'center',
					'text-transform' => 'none',
					'letter-spacing' => 0,
				),
				'color'        => false,
				'preview'      => true,
				'preview_text' => 'All', // Replace preview text with any text you like.
			),

		),
	)
);

//
// Metabox of the Real Testimonials.
// Set a unique slug-like ID.
//
$prefix_testimonial_opts = 'sp_tpro_meta_options';

//
// Testimonial metabox.
//
SPFTESTIMONIAL::createMetabox(
	$prefix_testimonial_opts,
	array(
		'title'     => __( 'Testimonial Options', 'testimonial-free' ),
		'class'     => 'spt-main-class',
		'post_type' => 'spt_testimonial',
		'context'   => 'normal',
	)
);

//
// Reviewer Information section.
//
SPFTESTIMONIAL::createSection(
	$prefix_testimonial_opts,
	array(
		'title'  => __( 'Reviewer Information', 'testimonial-free' ),
		'fields' => array(

			array(
				'id'       => 'tpro_name',
				'type'     => 'text',
				'title'    => __( 'Full Name', 'testimonial-free' ),
				'sanitize' => 'spftestimonial_sanitize_text',
			),
			array(
				'id'       => 'tpro_designation',
				'type'     => 'text',
				'title'    => __( 'Designation', 'testimonial-free' ),
				'sanitize' => 'spftestimonial_sanitize_text',
			),
			array(
				'id'       => 'tpro_rating',
				'type'     => 'rating',
				'title'    => __( 'Star Rating', 'testimonial-free' ),
				'options'  => array(
					'five_star'  => __( '5 Stars', 'testimonial-free' ),
					'four_star'  => __( '4 Stars', 'testimonial-free' ),
					'three_star' => __( '3 Stars', 'testimonial-free' ),
					'two_star'   => __( '2 Stars', 'testimonial-free' ),
					'one_star'   => __( '1 Star', 'testimonial-free' ),
				),
				'default'  => '',
				'sanitize' => 'spftestimonial_sanitize_text',
			),
			array(
				'type'    => 'notice',
				'class'   => 'sp-extra-field-notice ajax-notice',
				'content' => sprintf(
					/* translators: 1: start link tag, 2: close tag. */
					__( 'To unlock the following extra reviewer information fields, %1$sUpgrade to Pro!%2$s', 'testimonial-free' ),
					'<a target="_blank" href="https://realtestimonials.io/pricing/?ref=1"><b>',
					'</b></a>',
				),
			),
			array(
				'id'         => 'tpro_email',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'type'       => 'text',
				'title'      => __( 'E-mail Address', 'testimonial-free' ),
				'sanitize'   => 'sanitize_email',
			),

			array(
				'id'         => 'tpro_company_name',
				'type'       => 'text',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Company Name', 'testimonial-free' ),
				'sanitize'   => 'spftestimonial_sanitize_text',
			),
			array(
				'id'      => 'tpro_company_logo_pro',
				'class'   => 'pro_only_field tpro_company_logo_pro',
				'type'    => 'button_set',
				'title'   => __( 'Company Logo', 'testimonial-free' ),
				'options' => array(
					'upload' => __( 'Upload', 'testimonial-free' ),
				),
				'default' => 'upload',
			),
			array(
				'id'     => 'testimonial_clients_location',
				'class'  => 'sp-testimonial-location pro_only_field',
				'type'   => 'fieldset',
				'title'  => __( 'Location', 'testimonial-free' ),
				'fields' => array(
					array(
						'id'       => 'tpro_location',
						'type'     => 'text',
						'sanitize' => 'sp_tpro_sanitize_text',
					),
					array(
						'id'      => 'tpro_country',
						'type'    => 'select',
						'options' => 'select_country',
						'options' => array(
							'' => __( 'Select Country', 'testimonial-free' ),
						),
						'default' => '',
					),
				),
			),
			array(
				'id'         => 'tpro_phone',
				'type'       => 'text',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Phone or Mobile', 'testimonial-free' ),
				'sanitize'   => 'spftestimonial_sanitize_text',
			),
			array(
				'id'         => 'tpro_website',
				'type'       => 'text',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Website', 'testimonial-free' ),
				'sanitize'   => 'spftestimonial_sanitize_text',
			),
			array(
				'id'         => 'tpro_video_url',
				'type'       => 'text',
				'class'      => 'pro_only_field',
				'attributes' => array( 'disabled' => 'disabled' ),
				'title'      => __( 'Video Testimonial URL', 'testimonial-free' ),
				'sanitize'   => 'spftestimonial_sanitize_text',
			),
			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'ADDITIONAL CUSTOM FIELDS (PRO)', 'testimonial-free' ),
			),
			array(
				'id'           => 'testimonial_extra_fields',
				'type'         => 'repeater',
				'title'        => 'Reviewer Custom Information',
				'class'        => 'social-profile-repeater testimonial_extra_info addition_extra_fields_pro',
				'button_title' => esc_html__( 'Add Field', 'testimonial-free' ),
				'sort'         => true,
				'clone'        => false,
				'remove'       => true,
				'fields'       => array(
					array(
						'id'           => 'testimonial_extra_fields_icon',
						'type'         => 'icon',
						'button_title' => esc_html__( 'Add Icon', 'testimonial-free' ),
						'remove_title' => '<i class="fa fa-trash"></i>',
					),
					array(
						'id'          => 'testimonial_extra_fields_type',
						'type'        => 'select',
						'class'       => 'additional_custom_fields_pro',
						'options'     => array(
							'text'   => esc_html__( 'Text', 'testimonial-free' ),
							'number' => esc_html__( 'Number', 'testimonial-free' ),
							'email'  => esc_html__( 'Email', 'testimonial-free' ),
							'link'   => esc_html__( 'Link', 'testimonial-free' ),
							'date'   => esc_html__( 'Date', 'testimonial-free' ),
						),
						'placeholder' => 'Field type',
						'class'       => 'repeater-select',
					),
					array(
						'id'         => 'testimonial_extra_fields_value',
						'type'       => 'text',
						'attributes' => array( 'disabled' => 'disabled' ),
						'class'      => 'repeater-text pro_only_field',
					),
				),
				'default'      => array(
					array(),
				),
			),
			array(
				'type'    => 'subheading',
				'content' => __( 'SOCIAL MEDIA (PRO)', 'testimonial-free' ),
			),
			array(
				'id'           => 'tpro_social_profiles',
				'type'         => 'repeater',
				'title'        => esc_html__( 'Social Profiles', 'testimonial-free' ),
				'button_title' => esc_html__( 'Add Social', 'testimonial-free' ),
				'class'        => 'social-profile-repeater addition_extra_fields_pro',
				'attributes'   => array( 'disabled' => 'disabled' ),
				'clone'        => false,
				'fields'       => array(
					array(
						'id'          => 'social_name',
						'type'        => 'select',
						'class'       => 'social_name',
						'options'     => array(
							'facebook'       => __( 'Facebook', 'testimonial-free' ),
							'twitter'        => __( 'Twitter', 'testimonial-free' ),
							'linkedin'       => __( 'LinkedIn', 'testimonial-free' ),
							'skype'          => __( 'Skype', 'testimonial-free' ),
							'dropbox'        => __( 'dropbox', 'testimonial-free' ),
							'wordpress'      => __( 'WordPress', 'testimonial-free' ),
							'vimeo'          => __( 'vimeo', 'testimonial-free' ),
							'slideshare'     => __( 'SlideShare', 'testimonial-free' ),
							'vk'             => __( 'VK', 'testimonial-free' ),
							'tumblr'         => __( 'Tumblr', 'testimonial-free' ),
							'yahoo'          => __( 'Yahoo', 'testimonial-free' ),
							'pinterest'      => __( 'Pinterest', 'testimonial-free' ),
							'youtube'        => __( 'YouTube', 'testimonial-free' ),
							'stumbleupon'    => __( 'StumbleUpon', 'testimonial-free' ),
							'yahoo'          => __( 'Yahoo', 'testimonial-free' ),
							'reddit'         => __( 'Reddit', 'testimonial-free' ),
							'quora'          => __( 'Quora', 'testimonial-free' ),
							'yelp'           => __( 'Yelp', 'testimonial-free' ),
							'weibo'          => __( 'Weibo', 'testimonial-free' ),
							'product-hunt'   => __( 'ProductHunt', 'testimonial-free' ),
							'hacker-news'    => __( 'HackerNews', 'testimonial-free' ),
							'soundcloud'     => __( 'Soundcloud', 'testimonial-free' ),
							'whatsapp'       => __( 'WhatsApp', 'testimonial-free' ),
							'medium'         => __( 'Medium', 'testimonial-free' ),
							'vine'           => __( 'Vine', 'testimonial-free' ),
							'slack'          => __( 'Slack', 'testimonial-free' ),
							'instagram'      => __( 'Instagram', 'testimonial-free' ),
							'dribbble'       => __( 'Dribble', 'testimonial-free' ),
							'flickr'         => __( 'Flickr', 'testimonial-free' ),
							'foursquare'     => __( 'FourSquare', 'testimonial-free' ),
							'behance'        => __( 'Behance', 'testimonial-free' ),
							'snapchat'       => __( 'SnapChat', 'testimonial-free' ),
							'github'         => __( 'Github', 'testimonial-free' ),
							'bitbucket'      => __( 'Bitbucket', 'testimonial-free' ),
							'stack-overflow' => __( 'Stack Overflow', 'testimonial-free' ),
							'codepen'        => __( 'Codepen', 'testimonial-free' ),
						),
						'placeholder' => 'facebook',
						'default'     => 'facebook',
					),
					array(
						'id'         => 'social_url',
						'type'       => 'text',
						'class'      => 'pro_only_field',
						'attributes' => array( 'disabled' => 'disabled' ),
						'class'      => 'social-url',
					),
				),
				'default'      => array(
					array(),
				),
			),
		),
	)
);
